/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest.dataworker;

import com.google.common.base.Preconditions;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.ElementBuilder;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import java.io.File;
import java.time.ZonedDateTime;

public class DataWorkerData {
    private final VisibilityTranslator visibilityTranslator;
    private final Element element;
    private final Property property;
    private final String workspaceId;
    private final String visibilitySource;
    private final Priority priority;
    private final boolean traceEnabled;
    private File localFile;
    private long beforeActionTimestamp;
    private ElementOrPropertyStatus status;

    public DataWorkerData(VisibilityTranslator visibilityTranslator, Element element, Property property, String workspaceId, String visibilitySource, Priority priority, boolean traceEnabled) {
        Preconditions.checkNotNull((Object)((Object)priority), (Object)"priority cannot be null");
        this.visibilityTranslator = visibilityTranslator;
        this.element = element;
        this.property = property;
        this.workspaceId = workspaceId;
        this.visibilitySource = visibilitySource;
        this.priority = priority;
        this.traceEnabled = traceEnabled;
    }

    public DataWorkerData(VisibilityTranslator visibilityTranslator, Element element, Property property, String workspaceId, String visibilitySource, Priority priority, boolean traceEnabled, long beforeActionTimestamp, ElementOrPropertyStatus status) {
        Preconditions.checkNotNull((Object)((Object)priority), (Object)"priority cannot be null");
        this.visibilityTranslator = visibilityTranslator;
        this.element = element;
        this.property = property;
        this.workspaceId = workspaceId;
        this.visibilitySource = visibilitySource;
        this.priority = priority;
        this.beforeActionTimestamp = beforeActionTimestamp;
        this.status = status;
        this.traceEnabled = traceEnabled;
    }

    public Element getElement() {
        return this.element;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public Visibility getVisibility() {
        return this.getElement().getVisibility();
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getVisibilitySource() {
        return this.visibilitySource;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public long getBeforeActionTimestamp() {
        return this.beforeActionTimestamp;
    }

    public ElementOrPropertyStatus getPropertyStatus() {
        return this.status;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public VisibilityJson getVisibilitySourceJson() {
        if (this.getVisibilitySource() == null || this.getVisibilitySource().length() == 0) {
            return new VisibilityJson();
        }
        VisibilityJson visibilityJson = new VisibilityJson();
        visibilityJson.setSource(this.getVisibilitySource());
        return visibilityJson;
    }

    @Deprecated
    public VisibilityJson getVisibilityJson() {
        return this.getElementVisibilityJson();
    }

    public VisibilityJson getElementVisibilityJson() {
        VisibilityJson visibilityJson = (VisibilityJson)BcSchema.VISIBILITY_JSON.getPropertyValue(this.getElement());
        if (visibilityJson != null) {
            return visibilityJson;
        }
        return this.getVisibilitySourceJson();
    }

    public VisibilityJson getPropertyVisibilityJson() {
        VisibilityJson propertyVisibilityJson;
        if (this.property != null && (propertyVisibilityJson = (VisibilityJson)BcSchema.VISIBILITY_JSON_METADATA.getMetadataValue(this.property)) != null) {
            return propertyVisibilityJson;
        }
        return this.getElementVisibilityJson();
    }

    public Metadata createPropertyMetadata(User user) {
        Metadata metadata = Metadata.create();
        VisibilityJson visibilityJson = this.getPropertyVisibilityJson();
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        if (visibilityJson != null) {
            BcSchema.VISIBILITY_JSON_METADATA.setMetadata(metadata, visibilityJson, defaultVisibility);
        }
        BcSchema.MODIFIED_DATE_METADATA.setMetadata(metadata, ZonedDateTime.now(), defaultVisibility);
        BcSchema.MODIFIED_BY_METADATA.setMetadata(metadata, user.getUserId(), defaultVisibility);
        return metadata;
    }

    public void setVisibilityJsonOnElement(ElementBuilder builder) {
        VisibilityJson visibilityJson = this.getElementVisibilityJson();
        if (visibilityJson != null) {
            BcSchema.VISIBILITY_JSON.setProperty(builder, visibilityJson, this.visibilityTranslator.getDefaultVisibility());
        }
    }

    public void setVisibilityJsonOnElement(Element element, Authorizations authorizations) {
        VisibilityJson visibilityJson = this.getVisibilitySourceJson();
        if (visibilityJson != null) {
            BcSchema.VISIBILITY_JSON.setProperty(element, visibilityJson, this.visibilityTranslator.getDefaultVisibility(), authorizations);
        }
    }

    public String toString() {
        return "DataWorkerData{element=" + this.element + ", property=" + this.property + ", workspaceId='" + this.workspaceId + '\'' + ", priority=" + (Object)((Object)this.priority) + ", traceEnabled=" + this.traceEnabled + ", status=" + (Object)((Object)this.status) + '}';
    }
}

