/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest.dataworker;

import com.mware.core.model.properties.types.BcPropertyUpdate;
import com.mware.core.model.properties.types.BcPropertyUpdateRemove;
import com.mware.core.model.properties.types.BcPropertyUpdateUnhide;

public enum ElementOrPropertyStatus {
    HIDDEN,
    UNHIDDEN,
    DELETION,
    UPDATE;


    public static ElementOrPropertyStatus safeParse(String status) {
        try {
            if (status == null || status.length() == 0) {
                return UPDATE;
            }
            return ElementOrPropertyStatus.valueOf(status);
        }
        catch (Exception ex) {
            return UPDATE;
        }
    }

    public static ElementOrPropertyStatus getStatus(BcPropertyUpdate propertyUpdate) {
        if (propertyUpdate instanceof BcPropertyUpdateRemove && ((BcPropertyUpdateRemove)propertyUpdate).isDeleted()) {
            return DELETION;
        }
        if (propertyUpdate instanceof BcPropertyUpdateRemove && ((BcPropertyUpdateRemove)propertyUpdate).isHidden()) {
            return HIDDEN;
        }
        if (propertyUpdate instanceof BcPropertyUpdateUnhide) {
            return UNHIDDEN;
        }
        return UPDATE;
    }
}

