/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest.dataworker;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.exception.BcException;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.ingest.dataworker.MimeTypeDataWorkerConfiguration;
import com.mware.core.ingest.dataworker.PostMimeTypeWorker;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Element;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

@Singleton
public abstract class MimeTypeDataWorker
extends DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(MimeTypeDataWorker.class);
    public static final String MULTI_VALUE_KEY = MimeTypeDataWorker.class.getSimpleName();
    private final MimeTypeDataWorkerConfiguration configuration;
    private Collection<PostMimeTypeWorker> postMimeTypeWorkers;

    @Inject
    protected MimeTypeDataWorker(MimeTypeDataWorkerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        this.postMimeTypeWorkers = this.getPostMimeTypeWorkers();
        for (PostMimeTypeWorker postMimeTypeWorker : this.postMimeTypeWorkers) {
            try {
                postMimeTypeWorker.prepare(workerPrepareData);
            }
            catch (Exception ex) {
                throw new BcException("Could not prepare post mime type worker " + postMimeTypeWorker.getClass().getName(), ex);
            }
        }
    }

    protected Collection<PostMimeTypeWorker> getPostMimeTypeWorkers() {
        return InjectHelper.getInjectedServices(PostMimeTypeWorker.class, this.getConfiguration());
    }

    @Override
    public boolean isHandled(Element element, Property property) {
        if (property == null) {
            return false;
        }
        if (BcSchema.MIME_TYPE.hasProperty(element, this.getMultiKey(property))) {
            return false;
        }
        return this.configuration.isHandled(element, property);
    }

    @Override
    public void execute(InputStream in, DataWorkerData data) throws Exception {
        String fileName = (String)BcSchema.FILE_NAME.getOnlyPropertyValue(data.getElement());
        String dataPrepMimeType = (String)BcSchema.MIME_TYPE.getPropertyValue(data.getElement(), "dataprep");
        String mimeType = !StringUtils.isEmpty((CharSequence)dataPrepMimeType) ? dataPrepMimeType : this.getMimeType(in, fileName);
        if (mimeType == null) {
            return;
        }
        String propertyKey = this.getMultiKey(data.getProperty());
        ExistingVertexMutation m = ((Vertex)this.refresh(data.getElement())).prepareMutation();
        Metadata mimeTypeMetadata = data.createPropertyMetadata(this.getUser());
        BcSchema.MIME_TYPE.addPropertyValue(m, propertyKey, mimeType, mimeTypeMetadata, data.getProperty().getVisibility());
        m.setPropertyMetadata(data.getProperty(), BcSchema.MIME_TYPE.getPropertyName(), (Value)Values.stringValue(mimeType), this.getVisibilityTranslator().getDefaultVisibility());
        Vertex element = (Vertex)m.save(this.getAuthorizations());
        this.getGraph().flush();
        this.runPostMimeTypeWorkers(mimeType, data);
        if (this.getWebQueueRepository().shouldBroadcastGraphPropertyChange(data.getProperty().getName(), data.getPriority())) {
            this.getWebQueueRepository().broadcastPropertyChange(element, data.getProperty().getKey(), data.getProperty().getName(), data.getWorkspaceId());
        }
        if (this.getWebQueueRepository().shouldBroadcastGraphPropertyChange(BcSchema.MIME_TYPE.getPropertyName(), data.getPriority())) {
            this.getWebQueueRepository().broadcastPropertyChange(element, propertyKey, BcSchema.MIME_TYPE.getPropertyName(), data.getWorkspaceId());
        }
        this.getWorkQueueRepository().pushGraphPropertyQueue(element, propertyKey, BcSchema.MIME_TYPE.getPropertyName(), data.getWorkspaceId(), data.getVisibilitySource(), data.getPriority(), ElementOrPropertyStatus.UPDATE, null);
    }

    private String getMultiKey(Property property) {
        return MULTI_VALUE_KEY + property.getKey();
    }

    private void runPostMimeTypeWorkers(String mimeType, DataWorkerData data) {
        for (PostMimeTypeWorker postMimeTypeWorker : this.postMimeTypeWorkers) {
            try {
                LOGGER.debug("running PostMimeTypeWorker: %s on element: %s, mimeType: %s", postMimeTypeWorker.getClass().getName(), data.getElement().getId(), mimeType);
                postMimeTypeWorker.executeAndCleanup(mimeType, data, this.getAuthorizations());
            }
            catch (Exception ex) {
                throw new BcException("Failed running PostMimeTypeWorker " + postMimeTypeWorker.getClass().getName(), ex);
            }
        }
        if (this.postMimeTypeWorkers.size() > 0) {
            this.getGraph().flush();
        }
    }

    protected abstract String getMimeType(InputStream var1, String var2) throws Exception;
}

