/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest.dataworker;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configurable;
import com.mware.core.config.Configuration;
import com.mware.core.ingest.dataworker.MimeTypeDataWorker;
import com.mware.core.model.properties.BcSchema;
import com.mware.ge.Element;
import com.mware.ge.Property;
import java.util.HashSet;
import java.util.Set;

@Singleton
public class MimeTypeDataWorkerConfiguration {
    public static final String CONFIGURATION_PREFIX = MimeTypeDataWorker.class.getName();
    public static final String HANDLED_CONFIGURATION_PREFIX = CONFIGURATION_PREFIX + ".handled";
    private Set<String> handledPropertyNames = new HashSet<String>();

    @Inject
    public MimeTypeDataWorkerConfiguration(Configuration configuration) {
        for (Handled h : configuration.getMultiValueConfigurables(HANDLED_CONFIGURATION_PREFIX, Handled.class).values()) {
            this.handledPropertyNames.add(h.getPropertyName());
        }
        this.handledPropertyNames.add(BcSchema.RAW.getPropertyName());
    }

    public boolean isHandled(Element element, Property property) {
        return this.handledPropertyNames.contains(property.getName());
    }

    public static class Handled {
        @Configurable
        private String propertyName;

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

