/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest.dataworker;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.schema.Concept;
import com.mware.core.model.termMention.TermMentionBuilder;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Element;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexDataWorker
extends DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(RegexDataWorker.class);
    private final Pattern pattern;

    public RegexDataWorker(String regEx) {
        this.pattern = Pattern.compile(regEx, 8);
    }

    protected abstract Concept getConcept();

    @Override
    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        LOGGER.debug("Extractor prepared for entity type [%s] with regular expression: %s", this.getConcept().getName(), this.pattern.toString());
    }

    @Override
    public void execute(InputStream in, DataWorkerData data) throws Exception {
        LOGGER.debug("Extracting pattern [%s] from provided text", this.pattern);
        String text = CharStreams.toString((Readable)new InputStreamReader(in, Charsets.UTF_8));
        Matcher matcher = this.pattern.matcher(text);
        Vertex outVertex = (Vertex)data.getElement();
        ArrayList<Vertex> termMentions = new ArrayList<Vertex>();
        while (matcher.find()) {
            String patternGroup = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            Vertex termMention = new TermMentionBuilder().outVertex(outVertex).propertyKey(data.getProperty().getKey()).propertyName(data.getProperty().getName()).start(start).end(end).title(patternGroup).conceptName(this.getConcept().getName()).visibilityJson(data.getElementVisibilityJson()).process(this.getClass().getName()).save(this.getGraph(), this.getVisibilityTranslator(), this.getUser(), this.getAuthorizations());
            termMentions.add(termMention);
        }
        this.applyTermMentionFilters(outVertex, termMentions);
        this.pushTextUpdated(data);
    }

    @Override
    public boolean isHandled(Element element, Property property) {
        if (property == null) {
            return false;
        }
        if (property.getName().equals(BcSchema.RAW.getPropertyName())) {
            return false;
        }
        Value mimeType = property.getMetadata().getValue(BcSchema.MIME_TYPE.getPropertyName());
        return !mimeType.eq(Values.NO_VALUE) && ((TextValue)mimeType).stringValue().startsWith("text");
    }
}

