/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest.dataworker;

import com.mware.core.model.schema.SchemaRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VerifyResults {
    private List<Failure> failures = new ArrayList<Failure>();

    public boolean verifyRequiredPropertyIntent(SchemaRepository schemaRepository, String intentName) {
        String propertyName = schemaRepository.getPropertyNameByIntent(intentName, "public-ontology");
        if (propertyName == null || propertyName.length() == 0) {
            this.addFailure(new RequiredPropertyIntentFailure(intentName));
            return false;
        }
        return true;
    }

    public boolean verifyRequiredExecutable(String executableName) {
        try {
            ProcessBuilder procBuilder = new ProcessBuilder("which", executableName);
            Process proc = procBuilder.start();
            if (proc.waitFor() == 0) {
                return true;
            }
        }
        catch (Exception ex) {
            String[] pathParts;
            String path = System.getenv("PATH");
            for (String pathPart : pathParts = path.split(File.pathSeparator)) {
                if (!new File(pathPart, executableName).exists()) continue;
                return true;
            }
        }
        this.addFailure(new RequiredExecutableFailure(executableName));
        return false;
    }

    public void addFailure(Failure failure) {
        this.failures.add(failure);
    }

    public Collection<Failure> getFailures() {
        return this.failures;
    }

    public String toString() {
        return String.format("VerifyResults: %d failures", this.getFailures().size());
    }

    public static class GenericFailure
    extends Failure {
        private final String message;

        public GenericFailure(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private class RequiredExecutableFailure
    extends Failure {
        private final String executableName;

        public RequiredExecutableFailure(String executableName) {
            this.executableName = executableName;
        }

        public String getExecutableName() {
            return this.executableName;
        }

        @Override
        public String getMessage() {
            return String.format("Missing required executable: %s", this.getExecutableName());
        }
    }

    public static class RequiredPropertyIntentFailure
    extends Failure {
        private final String intentName;

        public RequiredPropertyIntentFailure(String intentName) {
            this.intentName = intentName;
        }

        public String getIntentName() {
            return this.intentName;
        }

        @Override
        public String getMessage() {
            return String.format("Missing required property intent: %s", this.getIntentName());
        }
    }

    public static abstract class Failure {
        public abstract String getMessage();

        public String toString() {
            return this.getMessage();
        }
    }
}

