/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest.video;

import com.mware.core.ingest.video.VideoFrameInfo;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.MediaBcSchema;
import com.mware.ge.Property;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VideoPropertyHelper {
    private static final Pattern START_TIME_AND_END_TIME_PATTERN = Pattern.compile("^(.*)\u001d" + MediaBcSchema.VIDEO_FRAME.getPropertyName() + '\u001d' + "([0-9]+)" + '\u001d' + "([0-9]+)");
    private static final Pattern START_TIME_ONLY_PATTERN = Pattern.compile("^(.*)\u001d" + MediaBcSchema.VIDEO_FRAME.getPropertyName() + '\u001d' + "([0-9]+)");

    public static VideoFrameInfo getVideoFrameInfoFromProperty(Property property) {
        String mimeType = BcSchema.MIME_TYPE_METADATA.getMetadataValueOrDefault(property.getMetadata(), null);
        if (mimeType == null || !mimeType.equals("text/plain")) {
            return null;
        }
        return VideoPropertyHelper.getVideoFrameInfo(property.getKey());
    }

    public static VideoFrameInfo getVideoFrameInfo(String propertyKey) {
        Matcher m = START_TIME_AND_END_TIME_PATTERN.matcher(propertyKey);
        if (m.find()) {
            return new VideoFrameInfo(Long.parseLong(m.group(2)), Long.parseLong(m.group(3)), m.group(1));
        }
        m = START_TIME_ONLY_PATTERN.matcher(propertyKey);
        if (m.find()) {
            return new VideoFrameInfo(Long.parseLong(m.group(2)), null, m.group(1));
        }
        return null;
    }
}

