/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.lifecycle;

import com.mware.core.lifecycle.LifecycleStatus;

public class LifecycleException
extends RuntimeException {
    public LifecycleException(Object instance, LifecycleStatus from, LifecycleStatus to, Throwable cause) {
        super(LifecycleException.humanReadableMessage(instance, from, to, cause), cause);
    }

    public LifecycleException(String message, Throwable cause) {
        super(message, cause);
    }

    private static String humanReadableMessage(Object instance, LifecycleStatus from, LifecycleStatus to, Throwable cause) {
        String instanceStr = String.valueOf(instance);
        StringBuilder message = new StringBuilder();
        switch (to) {
            case STOPPED: {
                if (from == LifecycleStatus.NONE) {
                    message.append("Component '").append(instanceStr).append("' failed to initialize");
                    break;
                }
                if (from != LifecycleStatus.STARTED) break;
                message.append("Component '").append(instanceStr).append("' failed to stop");
                break;
            }
            case STARTED: {
                if (from != LifecycleStatus.STOPPED) break;
                message.append("Component '").append(instanceStr).append("' was successfully initialized, but failed to start");
                break;
            }
            case SHUTDOWN: {
                message.append("Component '").append(instanceStr).append("' failed to shut down");
                break;
            }
        }
        if (message.length() == 0) {
            message.append("Component '").append(instanceStr).append("' failed to transition from ").append(from.name().toLowerCase()).append(" to ").append(to.name().toLowerCase());
        }
        message.append('.');
        if (cause != null) {
            Throwable root = LifecycleException.rootCause(cause);
            message.append(" Please see the attached cause exception \"").append(root.getMessage()).append('\"');
            if (root.getCause() != null) {
                message.append(" (root cause cycle detected)");
            }
            message.append('.');
        }
        return message.toString();
    }

    private static Throwable rootCause(Throwable cause) {
        int i = 0;
        while (cause.getCause() != null && i++ < 100) {
            cause = cause.getCause();
        }
        return cause;
    }
}

