/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.clientapi.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.mware.core.model.clientapi.dto.ClientApiObject;
import com.mware.core.model.clientapi.dto.PropertyType;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ClientApiSchema
implements ClientApiObject {
    private List<Concept> concepts = new ArrayList<Concept>();
    private List<Property> properties = new ArrayList<Property>();
    private List<Relationship> relationships = new ArrayList<Relationship>();

    public List<Concept> getConcepts() {
        return this.concepts;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public void addAllConcepts(Collection<Concept> concepts) {
        this.concepts.addAll(concepts);
    }

    public void addAllProperties(Collection<Property> properties) {
        this.properties.addAll(properties);
    }

    public void addAllRelationships(Collection<Relationship> relationships) {
        this.relationships.addAll(relationships);
    }

    public ClientApiSchema merge(Collection<Concept> mergeConcepts, Collection<Property> mergeProperties, Collection<Relationship> mergeRelationships) {
        ClientApiSchema copy = new ClientApiSchema();
        this.mergeCollections(copy.getConcepts(), this.concepts, mergeConcepts);
        this.mergeCollections(copy.getProperties(), this.properties, mergeProperties);
        this.mergeCollections(copy.getRelationships(), this.relationships, mergeRelationships);
        return copy;
    }

    private <T extends SchemaId> void mergeCollections(Collection<T> newList, Collection<T> old, Collection<T> merge) {
        if (merge == null || merge.size() == 0) {
            newList.addAll(old);
        } else {
            ArrayList<T> unmerged = new ArrayList<T>();
            unmerged.addAll(merge);
            for (SchemaId existing : old) {
                String existingName = existing.getTitle();
                SchemaId update = existing;
                for (SchemaId unmergedObject : unmerged) {
                    if (!unmergedObject.getTitle().equals(existingName)) continue;
                    update = unmergedObject;
                    unmerged.remove(unmergedObject);
                    break;
                }
                newList.add(update);
            }
            newList.addAll(unmerged);
        }
    }

    public static class Relationship
    implements ClientApiObject,
    SchemaId {
        private String[] relationshipClassAttibutes = new String[]{"parentIri", "title", "displayName", "userVisible", "analyticsVisible", "timeFormula", "color", "updateable", "deleteable", "titleFormula", "subtitleFormula", "coreConcept"};
        private String parentIri;
        private String title;
        private String displayName;
        private Boolean userVisible;
        private Boolean analyticsVisible;
        private Boolean updateable;
        private Boolean deleteable;
        private String titleFormula;
        private String subtitleFormula;
        private String timeFormula;
        private String color;
        private Boolean coreConcept;
        private List<String> domainConceptIris = new ArrayList<String>();
        private List<String> rangeConceptIris = new ArrayList<String>();
        private List<InverseOf> inverseOfs = new ArrayList<InverseOf>();
        private List<String> intents = new ArrayList<String>();
        private List<String> properties = new ArrayList<String>();
        private Map<String, String> metadata = new HashMap<String, String>();
        private SandboxStatus sandboxStatus;

        public JSONObject toJson() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            JSONObject json = new JSONObject();
            for (String string : this.relationshipClassAttibutes) {
                json.put(string, this.getClass().getMethod("get" + string.substring(0, 1).toUpperCase() + string.substring(1), new Class[0]).invoke((Object)this, new Object[0]));
            }
            JSONArray domainConceptsJSON = new JSONArray();
            for (String domainConceptIri : this.domainConceptIris) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("IRI", (Object)domainConceptIri);
                domainConceptsJSON.put((Object)jSONObject);
            }
            json.put("domainConcepts", (Object)domainConceptsJSON);
            JSONArray rangeConceptsJSON = new JSONArray();
            for (String string : this.rangeConceptIris) {
                JSONObject rangeConceptJSON = new JSONObject();
                rangeConceptJSON.put("IRI", (Object)string);
                rangeConceptsJSON.put((Object)rangeConceptJSON);
            }
            json.put("rangeConcepts", (Object)rangeConceptsJSON);
            JSONArray intentsJSON = new JSONArray();
            for (String intentIRI : this.intents) {
                JSONObject intentJSON = new JSONObject();
                intentJSON.put("intent", (Object)intentIRI);
                intentsJSON.put((Object)intentJSON);
            }
            json.put("intents", (Object)intentsJSON);
            JSONArray jSONArray = new JSONArray();
            for (String propertyIRI : this.properties) {
                JSONObject propertyJSON = new JSONObject();
                propertyJSON.put("IRI", (Object)propertyIRI);
                jSONArray.put((Object)propertyJSON);
            }
            json.put("properties", (Object)jSONArray);
            if (this.inverseOfs != null && !this.inverseOfs.isEmpty()) {
                for (InverseOf io : this.inverseOfs) {
                    json.put("inverseOf", (Object)io.getIri());
                }
            }
            return json;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getParentIri() {
            return this.parentIri;
        }

        public void setParentName(String parentIri) {
            this.parentIri = parentIri;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public List<String> getDomainConceptIris() {
            return this.domainConceptIris;
        }

        public void setDomainConceptNames(List<String> domainConceptIris) {
            this.domainConceptIris = domainConceptIris;
        }

        public List<String> getRangeConceptIris() {
            return this.rangeConceptIris;
        }

        public void setRangeConceptNames(List<String> rangeConceptIris) {
            this.rangeConceptIris = rangeConceptIris;
        }

        public Boolean getAnalyticsVisible() {
            return this.analyticsVisible;
        }

        public void setAnalyticVisible(Boolean analyticsVisible) {
            this.analyticsVisible = analyticsVisible;
        }

        public Boolean getUserVisible() {
            return this.userVisible;
        }

        public void setUserVisible(Boolean userVisible) {
            this.userVisible = userVisible;
        }

        public Boolean getUpdateable() {
            return this.updateable;
        }

        public void setUpdateable(Boolean updateable) {
            this.updateable = updateable;
        }

        public Boolean getDeleteable() {
            return this.deleteable;
        }

        public void setDeleteable(Boolean deleteable) {
            this.deleteable = deleteable;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        public void setProperties(List<String> properties) {
            this.properties = properties;
        }

        public String getTitleFormula() {
            return this.titleFormula;
        }

        public void setTitleFormula(String titleFormula) {
            this.titleFormula = titleFormula;
        }

        public String getSubtitleFormula() {
            return this.subtitleFormula;
        }

        public void setSubtitleFormula(String subtitleFormula) {
            this.subtitleFormula = subtitleFormula;
        }

        public String getTimeFormula() {
            return this.timeFormula;
        }

        public void setTimeFormula(String timeFormula) {
            this.timeFormula = timeFormula;
        }

        public void setCoreConcept(Boolean coreConcept) {
            this.coreConcept = coreConcept;
        }

        public Boolean getCoreConcept() {
            return this.coreConcept;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<InverseOf> getInverseOfs() {
            return this.inverseOfs;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<String> getIntents() {
            return this.intents;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public SandboxStatus getSandboxStatus() {
            return this.sandboxStatus;
        }

        public void setSandboxStatus(SandboxStatus sandboxStatus) {
            this.sandboxStatus = sandboxStatus;
        }

        public static class InverseOf {
            private String iri;
            private String primaryIri;

            public String getIri() {
                return this.iri;
            }

            public void setName(String iri) {
                this.iri = iri;
            }

            public String getPrimaryIri() {
                return this.primaryIri;
            }

            public void setPrimaryName(String primaryIri) {
                this.primaryIri = primaryIri;
            }
        }
    }

    public static class ExtendedDataTableProperty
    extends Property {
        private String titleFormula;
        private String subtitleFormula;
        private String timeFormula;
        private List<String> tablePropertyIris = new ArrayList<String>();

        public String getTitleFormula() {
            return this.titleFormula;
        }

        public void setTitleFormula(String titleFormula) {
            this.titleFormula = titleFormula;
        }

        public String getSubtitleFormula() {
            return this.subtitleFormula;
        }

        public void setSubtitleFormula(String subtitleFormula) {
            this.subtitleFormula = subtitleFormula;
        }

        public String getTimeFormula() {
            return this.timeFormula;
        }

        public void setTimeFormula(String timeFormula) {
            this.timeFormula = timeFormula;
        }

        public void setTablePropertyNames(List<String> tablePropertyIris) {
            this.tablePropertyIris.clear();
            this.tablePropertyIris.addAll(tablePropertyIris);
        }

        public List<String> getTablePropertyIris() {
            return this.tablePropertyIris;
        }
    }

    public static class Property
    implements ClientApiObject,
    SchemaId {
        private String[] propertyClassAttibutes = new String[]{"title", "displayName", "displayType", "userVisible", "analyticsVisible", "searchable", "addable", "sortable", "aggTimeZone", "aggCalendarField", "searchFacet", "aggType", "aggPrecision", "aggInterval", "aggMinDocumentCount", "propertyGroup", "systemProperty", "validationFormula", "displayFormula", "deleteable", "updateable"};
        private String title;
        private String displayName;
        private boolean userVisible;
        private boolean analyticsVisible;
        private boolean searchFacet;
        private boolean systemProperty;
        private String aggType;
        private int aggPrecision;
        private String aggInterval;
        private long aggMinDocumentCount;
        private String aggTimeZone;
        private String aggCalendarField;
        private boolean searchable;
        private boolean addable;
        private boolean sortable;
        private Integer sortPriority;
        private PropertyType dataType;
        private String displayType;
        private String propertyGroup;
        private Map<String, String> possibleValues = new HashMap<String, String>();
        private String validationFormula;
        private String displayFormula;
        private String[] dependentPropertyIris;
        private boolean deleteable;
        private boolean updateable;
        private List<String> intents = new ArrayList<String>();
        private List<String> textIndexHints = new ArrayList<String>();
        private Map<String, String> metadata = new HashMap<String, String>();
        private SandboxStatus sandboxStatus;

        public JSONObject toJson() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            JSONObject json = new JSONObject();
            for (String conceptAttribute : this.propertyClassAttibutes) {
                json.put(conceptAttribute, this.getClass().getMethod("get" + conceptAttribute.substring(0, 1).toUpperCase() + conceptAttribute.substring(1), new Class[0]).invoke((Object)this, new Object[0]));
            }
            json.put("dataType", (Object)this.dataType.toString());
            JSONArray possibleValuesJSON = new JSONArray();
            for (Map.Entry<String, String> possibleValue : this.possibleValues.entrySet()) {
                JSONObject possibleValueJSON = new JSONObject();
                possibleValueJSON.put("value", (Object)possibleValue.getKey());
                possibleValueJSON.put("displayName", (Object)possibleValue.getValue());
                possibleValuesJSON.put((Object)possibleValueJSON);
            }
            json.put("possibleValues", (Object)possibleValuesJSON);
            JSONArray dependentPropertiesJSON = new JSONArray();
            if (this.dependentPropertyIris != null) {
                for (String dependentProperty : this.dependentPropertyIris) {
                    possibleValuesJSON.put((Object)dependentProperty);
                }
                json.put("dependentProperties", (Object)dependentPropertiesJSON);
            }
            JSONArray intentsJSON = new JSONArray();
            if (this.intents != null) {
                for (String intent : this.intents) {
                    possibleValuesJSON.put((Object)intent);
                }
                json.put("intents", (Object)intentsJSON);
            }
            JSONArray textIndexHintsJSON = new JSONArray();
            if (this.textIndexHints != null) {
                for (String hint : this.textIndexHints) {
                    textIndexHintsJSON.put((Object)hint);
                }
                json.put("textIndexHints", (Object)textIndexHintsJSON);
            }
            return json;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean isAnalyticsVisible() {
            return this.analyticsVisible;
        }

        public boolean getAnalyticsVisible() {
            return this.analyticsVisible;
        }

        public void setAnalyticsVisible(boolean analyticsVisible) {
            this.analyticsVisible = analyticsVisible;
        }

        public boolean isSearchFacet() {
            return this.searchFacet;
        }

        public boolean getSearchFacet() {
            return this.searchFacet;
        }

        public void setSearchFacet(boolean searchFacet) {
            this.searchFacet = searchFacet;
        }

        public boolean isSystemProperty() {
            return this.systemProperty;
        }

        public boolean getSystemProperty() {
            return this.systemProperty;
        }

        public void setSystemProperty(boolean systemProperty) {
            this.systemProperty = systemProperty;
        }

        public String getAggType() {
            return this.aggType;
        }

        public void setAggType(String aggType) {
            this.aggType = aggType;
        }

        public int getAggPrecision() {
            return this.aggPrecision;
        }

        public void setAggPrecision(int aggPrecision) {
            this.aggPrecision = aggPrecision;
        }

        public String getAggInterval() {
            return this.aggInterval;
        }

        public void setAggInterval(String aggInterval) {
            this.aggInterval = aggInterval;
        }

        public long getAggMinDocumentCount() {
            return this.aggMinDocumentCount;
        }

        public void setAggMinDocumentCount(long aggMinDocumentCount) {
            this.aggMinDocumentCount = aggMinDocumentCount;
        }

        public String getAggTimeZone() {
            return this.aggTimeZone;
        }

        public void setAggTimeZone(String aggTimeZone) {
            this.aggTimeZone = aggTimeZone;
        }

        public String getAggCalendarField() {
            return this.aggCalendarField;
        }

        public void setAggCalendarField(String aggCalendarField) {
            this.aggCalendarField = aggCalendarField;
        }

        public boolean isUserVisible() {
            return this.userVisible;
        }

        public boolean getUserVisible() {
            return this.userVisible;
        }

        public void setUserVisible(boolean userVisible) {
            this.userVisible = userVisible;
        }

        public boolean isSearchable() {
            return this.searchable;
        }

        public boolean getSearchable() {
            return this.searchable;
        }

        public void setSearchable(boolean searchable) {
            this.searchable = searchable;
        }

        public boolean isAddable() {
            return this.addable;
        }

        public boolean getAddable() {
            return this.addable;
        }

        public void setAddable(boolean addable) {
            this.addable = addable;
        }

        public boolean isSortable() {
            return this.sortable;
        }

        public boolean getSortable() {
            return this.sortable;
        }

        public void setSortable(boolean sortable) {
            this.sortable = sortable;
        }

        public Integer getSortPriority() {
            return this.sortPriority;
        }

        public void setSortPriority(Integer sortPriority) {
            this.sortPriority = sortPriority;
        }

        public boolean isUpdateable() {
            return this.updateable;
        }

        public boolean getUpdateable() {
            return this.updateable;
        }

        public void setUpdateable(boolean updateable) {
            this.updateable = updateable;
        }

        public boolean isDeleteable() {
            return this.deleteable;
        }

        public boolean getDeleteable() {
            return this.deleteable;
        }

        public void setDeleteable(boolean deleteable) {
            this.deleteable = deleteable;
        }

        public PropertyType getDataType() {
            return this.dataType;
        }

        public void setDataType(PropertyType dataType) {
            this.dataType = dataType;
        }

        public String getDisplayType() {
            return this.displayType;
        }

        public void setDisplayType(String displayType) {
            this.displayType = displayType;
        }

        public String getPropertyGroup() {
            return this.propertyGroup;
        }

        public void setPropertyGroup(String propertyGroup) {
            this.propertyGroup = propertyGroup;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Map<String, String> getPossibleValues() {
            return this.possibleValues;
        }

        public void setValidationFormula(String validationFormula) {
            this.validationFormula = validationFormula;
        }

        public String getValidationFormula() {
            return this.validationFormula;
        }

        public void setDisplayFormula(String displayFormula) {
            this.displayFormula = displayFormula;
        }

        public String getDisplayFormula() {
            return this.displayFormula;
        }

        @JsonSetter
        public void setDependentPropertyNames(String[] dependentPropertyIris) {
            this.dependentPropertyIris = dependentPropertyIris;
        }

        public void setDependentPropertyNames(Collection<String> dependentPropertyIris) {
            this.dependentPropertyIris = dependentPropertyIris == null || dependentPropertyIris.size() == 0 ? null : dependentPropertyIris.toArray(new String[dependentPropertyIris.size()]);
        }

        public String[] getDependentPropertyIris() {
            return this.dependentPropertyIris;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<String> getIntents() {
            return this.intents;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<String> getTextIndexHints() {
            return this.textIndexHints;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setTextIndexHints(List<String> textIndexHints) {
            this.textIndexHints = textIndexHints;
        }

        public SandboxStatus getSandboxStatus() {
            return this.sandboxStatus;
        }

        public void setSandboxStatus(SandboxStatus sandboxStatus) {
            this.sandboxStatus = sandboxStatus;
        }
    }

    public static class Concept
    implements ClientApiObject,
    SchemaId {
        private String[] conceptClassAttibutes = new String[]{"id", "title", "displayName", "displayType", "titleFormula", "subtitleFormula", "timeFormula", "parentConcept", "pluralDisplayName", "userVisible", "analyticsVisible", "searchable", "glyphIconHref", "glyphIconSelectedHref", "color", "deleteable", "updateable", "coreConcept"};
        private Boolean coreConcept;
        private String id;
        private String title;
        private String displayName;
        private String displayType;
        private String titleFormula;
        private String subtitleFormula;
        private String timeFormula;
        private String parentConcept;
        private String pluralDisplayName;
        private Boolean userVisible;
        private Boolean analyticsVisible;
        private Boolean searchable;
        private String glyphIconHref;
        private String glyphIconSelectedHref;
        private String color;
        private Boolean deleteable;
        private Boolean updateable;
        private List<String> intents = new ArrayList<String>();
        private List<String> addRelatedConceptWhiteList = new ArrayList<String>();
        private List<String> properties = new ArrayList<String>();
        private Map<String, String> metadata = new HashMap<String, String>();
        private SandboxStatus sandboxStatus;

        public JSONObject toJson() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            JSONObject json = new JSONObject();
            for (String conceptAttribute : this.conceptClassAttibutes) {
                json.put(conceptAttribute, this.getClass().getMethod("get" + conceptAttribute.substring(0, 1).toUpperCase() + conceptAttribute.substring(1), new Class[0]).invoke((Object)this, new Object[0]));
            }
            return json;
        }

        public Boolean getCoreConcept() {
            return this.coreConcept;
        }

        public void setCoreConcept(Boolean coreConcept) {
            this.coreConcept = coreConcept;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayType() {
            return this.displayType;
        }

        public void setDisplayType(String displayType) {
            this.displayType = displayType;
        }

        public String getTitleFormula() {
            return this.titleFormula;
        }

        public void setTitleFormula(String titleFormula) {
            this.titleFormula = titleFormula;
        }

        public String getSubtitleFormula() {
            return this.subtitleFormula;
        }

        public void setSubtitleFormula(String subtitleFormula) {
            this.subtitleFormula = subtitleFormula;
        }

        public String getTimeFormula() {
            return this.timeFormula;
        }

        public void setTimeFormula(String timeFormula) {
            this.timeFormula = timeFormula;
        }

        public String getParentConcept() {
            return this.parentConcept;
        }

        public void setParentConcept(String parentConcept) {
            this.parentConcept = parentConcept;
        }

        public String getPluralDisplayName() {
            return this.pluralDisplayName;
        }

        public void setPluralDisplayName(String pluralDisplayName) {
            this.pluralDisplayName = pluralDisplayName;
        }

        public Boolean getUserVisible() {
            return this.userVisible;
        }

        public void setUserVisible(Boolean userVisible) {
            this.userVisible = userVisible;
        }

        public Boolean getAnalyticsVisible() {
            return this.analyticsVisible;
        }

        public void setAnalyticsVisible(boolean analyticsVisible) {
            this.analyticsVisible = analyticsVisible;
        }

        public Boolean getSearchable() {
            return this.searchable;
        }

        public void setSearchable(Boolean searchable) {
            this.searchable = searchable;
        }

        public String getGlyphIconHref() {
            return this.glyphIconHref;
        }

        public void setGlyphIconHref(String glyphIconHref) {
            this.glyphIconHref = glyphIconHref;
        }

        public String getGlyphIconSelectedHref() {
            return this.glyphIconSelectedHref;
        }

        public void setGlyphIconSelectedHref(String glyphIconSelectedHref) {
            this.glyphIconSelectedHref = glyphIconSelectedHref;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public Boolean getUpdateable() {
            return this.updateable;
        }

        public void setUpdateable(Boolean updateable) {
            this.updateable = updateable;
        }

        public Boolean getDeleteable() {
            return this.deleteable;
        }

        public void setDeleteable(Boolean deleteable) {
            this.deleteable = deleteable;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<String> getAddRelatedConceptWhiteList() {
            return this.addRelatedConceptWhiteList;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<String> getIntents() {
            return this.intents;
        }

        public SandboxStatus getSandboxStatus() {
            return this.sandboxStatus;
        }

        public void setSandboxStatus(SandboxStatus sandboxStatus) {
            this.sandboxStatus = sandboxStatus;
        }
    }

    static interface SchemaId {
        public String getTitle();
    }
}

