/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.clientapi.dto;

import com.mware.core.model.clientapi.dto.ClientApiEdge;
import com.mware.core.model.clientapi.dto.ClientApiEdgeSearchResponse;
import com.mware.core.model.clientapi.dto.ClientApiElementSearchResponse;
import com.mware.core.model.clientapi.dto.ClientApiGeoPoint;
import com.mware.core.model.clientapi.dto.ClientApiGeoRect;
import com.mware.core.model.clientapi.dto.ClientApiObject;
import com.mware.core.model.clientapi.dto.ClientApiScalarSearchResponse;
import com.mware.core.model.clientapi.dto.ClientApiVertex;
import com.mware.core.model.clientapi.util.ClientApiConverter;
import com.mware.core.model.search.SearchResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ClientApiSearchResponse
extends SearchResults
implements ClientApiObject {
    private Integer nextOffset = null;
    private Long retrievalTime = null;
    private Long totalTime = null;
    private Long totalHits = null;
    private Long searchTime = null;
    private Map<String, AggregateResult> aggregates = new HashMap<String, AggregateResult>();

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        return ClientApiConverter.clientApiToString(this);
    }

    public abstract int getItemCount();

    public static ClientApiSearchResponse listToClientApiSearchResponse(List<List<Object>> rows) {
        ClientApiSearchResponse results;
        if (rows == null || rows.size() == 0) {
            results = new ClientApiElementSearchResponse();
        } else if (rows.get(0).size() == 1 && rows.get(0).get(0) instanceof ClientApiVertex) {
            results = new ClientApiElementSearchResponse();
            ((ClientApiElementSearchResponse)results).getElements().addAll(ClientApiSearchResponse.toClientApiVertex(rows));
        } else if (rows.get(0).size() == 1 && rows.get(0).get(0) instanceof ClientApiEdge) {
            results = new ClientApiEdgeSearchResponse();
            ((ClientApiEdgeSearchResponse)results).getResults().addAll(ClientApiSearchResponse.toClientApiEdge(rows));
        } else {
            results = new ClientApiScalarSearchResponse();
            ((ClientApiScalarSearchResponse)results).getResults().addAll(rows);
        }
        return results;
    }

    private static Collection<ClientApiVertex> toClientApiVertex(List<List<Object>> rows) {
        ArrayList<ClientApiVertex> results = new ArrayList<ClientApiVertex>();
        for (List<Object> row : rows) {
            results.add((ClientApiVertex)row.get(0));
        }
        return results;
    }

    private static Collection<ClientApiEdge> toClientApiEdge(List<List<Object>> rows) {
        ArrayList<ClientApiEdge> results = new ArrayList<ClientApiEdge>();
        for (List<Object> row : rows) {
            results.add((ClientApiEdge)row.get(0));
        }
        return results;
    }

    public Integer getNextOffset() {
        return this.nextOffset;
    }

    public Long getRetrievalTime() {
        return this.retrievalTime;
    }

    public Long getTotalTime() {
        return this.totalTime;
    }

    public Long getTotalHits() {
        return this.totalHits;
    }

    public Long getSearchTime() {
        return this.searchTime;
    }

    public Map<String, AggregateResult> getAggregates() {
        return this.aggregates;
    }

    public void setNextOffset(Integer nextOffset) {
        this.nextOffset = nextOffset;
    }

    public void setRetrievalTime(Long retrievalTime) {
        this.retrievalTime = retrievalTime;
    }

    public void setTotalTime(Long totalTime) {
        this.totalTime = totalTime;
    }

    public void setTotalHits(Long totalHits) {
        this.totalHits = totalHits;
    }

    public void setSearchTime(Long searchTime) {
        this.searchTime = searchTime;
    }

    public void setAggregates(Map<String, AggregateResult> aggregates) {
        this.aggregates = aggregates;
    }

    public static class MaxAggregateResult
    extends AggregateResult {
        private double value;

        public MaxAggregateResult() {
            super("max");
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    public static class MinAggregateResult
    extends AggregateResult {
        private double value;

        public MinAggregateResult() {
            super("min");
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    public static class AvgAggregateResult
    extends AggregateResult {
        private double value;

        public AvgAggregateResult() {
            super("avg");
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    public static class SumAggregateResult
    extends AggregateResult {
        private double value;

        public SumAggregateResult() {
            super("sum");
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    public static class StatisticsAggregateResult
    extends AggregateResult {
        private long count;
        private double average;
        private double min;
        private double max;
        private double standardDeviation;
        private double sum;

        public StatisticsAggregateResult() {
            super("statistics");
        }

        public long getCount() {
            return this.count;
        }

        public double getAverage() {
            return this.average;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getStandardDeviation() {
            return this.standardDeviation;
        }

        public double getSum() {
            return this.sum;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public void setAverage(double average) {
            this.average = average;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public void setStandardDeviation(double standardDeviation) {
            this.standardDeviation = standardDeviation;
        }

        public void setSum(double sum) {
            this.sum = sum;
        }
    }

    public static class HistogramAggregateResult
    extends AggregateResult {
        private Map<String, Bucket> buckets = new HashMap<String, Bucket>();
        private String fieldType;
        private String min;
        private String max;

        public HistogramAggregateResult() {
            super("histogram");
        }

        public Map<String, Bucket> getBuckets() {
            return this.buckets;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public void setBuckets(Map<String, Bucket> buckets) {
            this.buckets = buckets;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public void setMin(String min) {
            this.min = min;
        }

        public void setMax(String max) {
            this.max = max;
        }

        public static class Bucket
        extends AggregateResult.BucketBase {
            private final long count;
            private String fromValue;
            private String toValue;

            public Bucket(long count, Map<String, AggregateResult> nestedResults) {
                super(nestedResults);
                this.count = count;
            }

            public long getCount() {
                return this.count;
            }

            public String getFromValue() {
                return this.fromValue;
            }

            public String getToValue() {
                return this.toValue;
            }

            public void setFromValue(String fromValue) {
                this.fromValue = fromValue;
            }

            public void setToValue(String toValue) {
                this.toValue = toValue;
            }
        }
    }

    public static class GeohashAggregateResult
    extends AggregateResult {
        private long maxCount;
        private Map<String, Bucket> buckets = new HashMap<String, Bucket>();

        public GeohashAggregateResult() {
            super("geohash");
        }

        public long getMaxCount() {
            return this.maxCount;
        }

        public Map<String, Bucket> getBuckets() {
            return this.buckets;
        }

        public void setMaxCount(long maxCount) {
            this.maxCount = maxCount;
        }

        public void setBuckets(Map<String, Bucket> buckets) {
            this.buckets = buckets;
        }

        public static class Bucket
        extends AggregateResult.BucketBase {
            private final ClientApiGeoRect cell;
            private final ClientApiGeoPoint point;
            private final long count;

            public Bucket(ClientApiGeoRect cell, ClientApiGeoPoint point, long count, Map<String, AggregateResult> nestedResults) {
                super(nestedResults);
                this.cell = cell;
                this.point = point;
                this.count = count;
            }

            public ClientApiGeoRect getCell() {
                return this.cell;
            }

            public ClientApiGeoPoint getPoint() {
                return this.point;
            }

            public long getCount() {
                return this.count;
            }
        }
    }

    public static class TermsAggregateResult
    extends AggregateResult {
        private Map<String, Bucket> buckets = new LinkedHashMap<String, Bucket>();

        public TermsAggregateResult() {
            super("term");
        }

        public Map<String, Bucket> getBuckets() {
            return this.buckets;
        }

        public static class Bucket
        extends AggregateResult.BucketBase {
            private final long count;
            private String label;

            public Bucket(long count, Map<String, AggregateResult> nestedResults) {
                super(nestedResults);
                this.count = count;
            }

            public long getCount() {
                return this.count;
            }
        }
    }

    public static abstract class AggregateResult {
        private String type;
        private String field;
        private boolean orderedByNestedAgg = false;

        public AggregateResult(String type) {
            this.setType(type);
        }

        public String getType() {
            return this.type;
        }

        public String getField() {
            return this.field;
        }

        public boolean isOrderedByNestedAgg() {
            return this.orderedByNestedAgg;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setOrderedByNestedAgg(boolean orderedByNestedAgg) {
            this.orderedByNestedAgg = orderedByNestedAgg;
        }

        public static abstract class BucketBase {
            private final Map<String, AggregateResult> nestedResults;
            private String label;

            protected BucketBase(Map<String, AggregateResult> nestedResults) {
                this.nestedResults = nestedResults;
            }

            public Map<String, AggregateResult> getNestedResults() {
                return this.nestedResults;
            }

            public String getLabel() {
                return this.label;
            }

            public void setLabel(String label) {
                this.label = label;
            }
        }
    }
}

