/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.clientapi.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.json.JSONObject;

public class GraphPosition {
    private int x;
    private int y;

    @JsonCreator
    protected GraphPosition() {
    }

    public GraphPosition(JSONObject position) {
        this(position.optInt("x", 0), position.optInt("y", 0));
    }

    public GraphPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void add(GraphPosition graphPosition) {
        this.x += graphPosition.getX();
        this.y += graphPosition.getY();
    }

    public void subtract(GraphPosition graphPosition) {
        this.x -= graphPosition.getX();
        this.y -= graphPosition.getY();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphPosition that = (GraphPosition)o;
        if (this.x != that.x) {
            return false;
        }
        return this.y == that.y;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        return result;
    }

    public String toString() {
        return "GraphPosition{x=" + this.x + ", y=" + this.y + '}';
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put("x", this.x);
        json.put("y", this.y);
        return json;
    }

    public static GraphPosition fromJSONObject(JSONObject json) {
        if (json == null) {
            return null;
        }
        return new GraphPosition(json);
    }
}

