/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.clientapi.dto;

import com.fasterxml.jackson.annotation.JsonValue;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.ByteValue;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.FloatValue;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.GeoShapeValue;
import com.mware.ge.values.storable.LongValue;
import com.mware.ge.values.storable.StringArray;
import com.mware.ge.values.storable.StringValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;

public enum PropertyType {
    DATE("date"),
    STRING("string"),
    GEO_LOCATION("geoLocation"),
    GEO_SHAPE("geoshape"),
    IMAGE("image"),
    BINARY("binary"),
    CURRENCY("currency"),
    DOUBLE("double"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    DIRECTORY_ENTITY("directory/entity"),
    EXTENDED_DATA_TABLE("extendedDataTable"),
    UNKNOWN("unknown");

    public static final String GE_TYPE_GEO_POINT = "com.mware.ge.type.GeoPoint";
    public static final String GE_TYPE_GEO_SHAPE = "com.mware.ge.type.GeoShape";
    private final String text;

    private PropertyType(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    @JsonValue
    public String getText() {
        return this.text;
    }

    public static PropertyType convert(String property) {
        return PropertyType.convert(property, STRING);
    }

    public static PropertyType convert(String property, PropertyType defaultValue) {
        for (PropertyType pt : PropertyType.values()) {
            if (!pt.toString().equalsIgnoreCase(property)) continue;
            return pt;
        }
        return defaultValue;
    }

    public static Class<? extends Value> getTypeClass(PropertyType propertyType) {
        switch (propertyType) {
            case DATE: {
                return DateTimeValue.class;
            }
            case STRING: 
            case DIRECTORY_ENTITY: {
                return StringValue.class;
            }
            case GEO_LOCATION: {
                return GeoPointValue.class;
            }
            case GEO_SHAPE: {
                return GeoShapeValue.class;
            }
            case EXTENDED_DATA_TABLE: {
                return StringArray.class;
            }
            case IMAGE: 
            case BINARY: {
                return ByteValue.class;
            }
            case CURRENCY: {
                return FloatValue.class;
            }
            case BOOLEAN: {
                return BooleanValue.class;
            }
            case DOUBLE: {
                return DoubleValue.class;
            }
            case INTEGER: {
                return LongValue.class;
            }
            case UNKNOWN: {
                return TextValue.class;
            }
        }
        throw new RuntimeException("Unhandled property type: " + (Object)((Object)propertyType));
    }
}

