/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.clientapi.dto;

import com.mware.core.model.clientapi.dto.VisibilityJson;
import java.util.Set;

public enum SandboxStatus {
    PUBLIC,
    PUBLIC_CHANGED,
    PRIVATE;


    public static SandboxStatus getFromVisibilityString(String visibility, String workspaceId) {
        if (visibility == null) {
            return PUBLIC;
        }
        if (workspaceId == null || !visibility.contains(workspaceId)) {
            return PUBLIC;
        }
        return PRIVATE;
    }

    public static SandboxStatus getFromVisibilityJsonString(VisibilityJson visibilityJson, String workspaceId) {
        if (visibilityJson == null) {
            return PUBLIC;
        }
        Set<String> workspacesList = visibilityJson.getWorkspaces();
        if (workspacesList == null || workspacesList.size() == 0) {
            return PUBLIC;
        }
        if (workspaceId == null || !workspacesList.contains(workspaceId)) {
            return PUBLIC;
        }
        return PRIVATE;
    }
}

