/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.clientapi.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.clientapi.util.ObjectMapperFactory;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ClientApiConverter {
    public static Object toClientApiValue(Object value) {
        if (value instanceof JSONArray) {
            return ClientApiConverter.toClientApiValue((JSONArray)value);
        }
        if (value instanceof JSONObject) {
            return ClientApiConverter.toClientApiValueInternal((JSONObject)value);
        }
        if (JSONObject.NULL.equals(value)) {
            return null;
        }
        if (value instanceof TextValue) {
            return ClientApiConverter.toClientApiValue((TextValue)value);
        }
        if (value instanceof DateTimeValue) {
            return ClientApiConverter.toClientApiValue(((ZonedDateTime)((DateTimeValue)value).asObjectCopy()).toInstant().toEpochMilli());
        }
        if (value instanceof Value) {
            return ((Value)value).asObjectCopy();
        }
        return value;
    }

    private static List<Object> toClientApiValue(JSONArray json) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < json.length(); ++i) {
            Object obj = json.get(i);
            result.add(ClientApiConverter.toClientApiValue(obj));
        }
        return result;
    }

    private static Object toClientApiValue(TextValue value) {
        String valueString = value.stringValue();
        try {
            valueString = valueString.trim();
            if (valueString.startsWith("{") && valueString.endsWith("}")) {
                return ClientApiConverter.toClientApiValue((Object)new JSONObject(valueString));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valueString;
    }

    private static Object toClientApiValueInternal(JSONObject json) {
        if (json.length() == 2 && json.has("source") && json.has("workspaces")) {
            VisibilityJson visibilityJson = new VisibilityJson();
            visibilityJson.setSource(json.getString("source"));
            JSONArray workspacesJson = json.getJSONArray("workspaces");
            for (int i = 0; i < workspacesJson.length(); ++i) {
                visibilityJson.addWorkspace(workspacesJson.getString(i));
            }
            return visibilityJson;
        }
        return ClientApiConverter.toClientApiValue(json);
    }

    public static Map<String, Object> toClientApiValue(JSONObject json) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object key : json.keySet()) {
            String keyStr = (String)key;
            result.put(keyStr, ClientApiConverter.toClientApiValue(json.get(keyStr)));
        }
        return result;
    }

    public static Object fromClientApiValue(Object obj) {
        Map map;
        if (obj instanceof Map && VisibilityJson.isVisibilityJson(map = (Map)obj)) {
            return VisibilityJson.fromMap(map);
        }
        return obj;
    }

    public static String clientApiToString(Object o) {
        if (o == null) {
            throw new RuntimeException("o cannot be null.");
        }
        try {
            return ObjectMapperFactory.getInstance().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not convert object '" + o.getClass().getName() + "' to string", e);
        }
    }

    public static <T> T toClientApi(JSONObject json, Class<T> clazz) {
        return ClientApiConverter.toClientApi(json.toString(), clazz);
    }

    public static <T> T toClientApi(String str, Class<T> clazz) {
        try {
            return (T)ObjectMapperFactory.getInstance().readValue(str, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse '" + str + "' to class '" + clazz.getName() + "'", e);
        }
    }

    public static <T> Map<String, T> toClientApiMap(String str, Class<T> clazz) {
        try {
            MapType typeRef = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, clazz);
            return (Map)ObjectMapperFactory.getInstance().readValue(str, (JavaType)typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse '" + str + "' to class '" + clazz.getName() + "'", e);
        }
    }
}

