/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.clientapi.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import org.json.JSONObject;

public class ObjectMapperFactory {
    private static ObjectMapper mapper;

    public static ObjectMapper getInstance() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.registerModule(ObjectMapperFactory.createBcObjectMapperModule());
            mapper.registerModule((Module)new JavaTimeModule());
        }
        return mapper;
    }

    private static Module createBcObjectMapperModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(JSONObject.NULL.getClass(), (JsonSerializer)new JSONObjectNullSerializer());
        return simpleModule;
    }

    private static class JSONObjectNullSerializer
    extends JsonSerializer<Object> {
        private JSONObjectNullSerializer() {
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNull();
        }
    }
}

