/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.file;

import com.mware.core.exception.BcException;
import com.mware.core.model.file.FileSystemRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ClassPathFileSystemRepository
extends FileSystemRepository {
    private final String prefix;

    public ClassPathFileSystemRepository(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public File getLocalFileFor(String path) {
        InputStream in = this.getInputStream(path);
        File tempFile = new File(System.getProperty("java.io.tmpdir"), new File(path).getName());
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            throw new BcException("Could not copy file: " + path + " to " + tempFile, ex);
        }
        return tempFile;
    }

    @Override
    public InputStream getInputStream(String path) {
        String fullPath = this.prefix + path;
        InputStream in = this.getClass().getResourceAsStream(fullPath);
        if (in == null) {
            throw new BcException("Could not find classpath file: " + fullPath);
        }
        return in;
    }

    @Override
    public Iterable<String> list(String path) {
        throw new BcException("Unsupported operation");
    }
}

