/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.file;

import com.google.common.collect.Lists;
import com.mware.core.config.FileConfigurationLoader;
import com.mware.core.exception.BcException;
import com.mware.core.model.file.FileSystemRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class LocalFileSystemRepository
extends FileSystemRepository {
    @Override
    public File getLocalFileFor(String path) {
        File result = FileConfigurationLoader.resolveLocalFileName(path);
        if (result.exists()) {
            return result;
        }
        throw new BcException("Could not find file: " + path);
    }

    @Override
    public InputStream getInputStream(String path) {
        try {
            return new FileInputStream(this.getLocalFileFor(path));
        }
        catch (FileNotFoundException ex) {
            throw new BcException("Could not find file: " + path, ex);
        }
    }

    @Override
    public Iterable<String> list(String path) {
        return Lists.newArrayList((Object[])this.getLocalFileFor(path).list());
    }
}

