/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.graph;

import com.google.common.base.Preconditions;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.types.BcPropertyUpdate;
import com.mware.core.model.properties.types.PropertyMetadata;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.EdgeMutation;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.mutation.VertexMutation;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class ElementUpdateContext<T extends Element> {
    private final VisibilityTranslator visibilityTranslator;
    private final ElementMutation<T> mutation;
    private final User user;
    private final List<BcPropertyUpdate> properties = new ArrayList<BcPropertyUpdate>();
    private final T element;

    public ElementUpdateContext(VisibilityTranslator visibilityTranslator, ElementMutation<T> mutation, User user) {
        this.visibilityTranslator = visibilityTranslator;
        this.mutation = mutation;
        this.user = user;
        this.element = mutation instanceof ExistingElementMutation ? ((ExistingElementMutation)mutation).getElement() : null;
    }

    public boolean isNewElement() {
        return this.getElement() == null;
    }

    public ElementMutation<T> getMutation() {
        return this.mutation;
    }

    public List<BcPropertyUpdate> getProperties() {
        return this.properties;
    }

    public T getElement() {
        return this.element;
    }

    public void updateBuiltInProperties(ZonedDateTime modifiedDate, VisibilityJson visibilityJson) {
        Preconditions.checkNotNull((Object)this.user, (Object)"User cannot be null");
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        if (this.user != null) {
            BcSchema.MODIFIED_BY.updateProperty(this, this.user.getUserId(), defaultVisibility);
        }
        BcSchema.MODIFIED_DATE.updateProperty(this, modifiedDate, defaultVisibility);
        BcSchema.VISIBILITY_JSON.updateProperty(this, visibilityJson, defaultVisibility);
    }

    public void updateBuiltInProperties(PropertyMetadata propertyMetadata) {
        this.updateBuiltInProperties(propertyMetadata.getModifiedDate(), propertyMetadata.getVisibilityJson());
    }

    public void setConceptType(String conceptType) {
        if (this.isEdgeMutation()) {
            throw new IllegalArgumentException("Cannot set concept type on edges");
        }
        ((VertexMutation)this.mutation).alterConceptType(conceptType);
    }

    private boolean isEdgeMutation() {
        ExistingElementMutation m;
        if (this.getMutation() instanceof EdgeMutation) {
            return true;
        }
        return this.getMutation() instanceof ExistingElementMutation && (m = (ExistingElementMutation)this.getMutation()).getElement() instanceof Edge;
    }
}

