/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.graph;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.exception.BcResourceNotFoundException;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.model.clientapi.dto.ClientApiSourceInfo;
import com.mware.core.model.clientapi.dto.SandboxStatus;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.graph.GraphUpdateContext;
import com.mware.core.model.graph.VisibilityAndElementMutation;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.termMention.TermMentionFor;
import com.mware.core.model.termMention.TermMentionRepository;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.security.BcVisibility;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.GeMetadataUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.Element;
import com.mware.ge.ElementBuilder;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.values.storable.Value;
import java.time.ZonedDateTime;

public class GraphRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(GraphRepository.class);
    public static final String BC_VERSION_KEY = "bc.version";
    public static final int BC_VERSION = 4;
    private final Graph graph;
    private final VisibilityTranslator visibilityTranslator;
    private final TermMentionRepository termMentionRepository;
    private final WorkQueueRepository workQueueRepository;
    private final WebQueueRepository webQueueRepository;
    private final Boolean autoPublish;
    public static final String WORKSPACE_AUTO_PUBLISH_KEY = "workspace.autopublish";

    @Inject
    public GraphRepository(Graph graph, VisibilityTranslator visibilityTranslator, TermMentionRepository termMentionRepository, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, Configuration configuration) {
        this.graph = graph;
        this.visibilityTranslator = visibilityTranslator;
        this.termMentionRepository = termMentionRepository;
        this.workQueueRepository = workQueueRepository;
        this.webQueueRepository = webQueueRepository;
        this.autoPublish = configuration.getBoolean(WORKSPACE_AUTO_PUBLISH_KEY, false);
    }

    public void verifyVersion() {
        this.verifyVersion(4);
    }

    public void verifyVersion(int requiredVersion) {
        Object version = this.graph.getMetadata(BC_VERSION_KEY);
        if (version == null) {
            this.writeVersion();
            return;
        }
        if (!(version instanceof Integer)) {
            throw new BcException("Invalid bc.version found. Expected Integer, found " + version.getClass().getName());
        }
        Integer versionInt = (Integer)version;
        if (versionInt != requiredVersion) {
            throw new BcException("Incompatible graph version (bc.version) found. Expected " + requiredVersion + ", found " + versionInt);
        }
        LOGGER.info("BigConnect graph version verified: %d", versionInt);
    }

    public void writeVersion() {
        this.writeVersion(4);
    }

    public void writeVersion(int version) {
        this.graph.setMetadata(BC_VERSION_KEY, version);
        LOGGER.info("Wrote %s: %d", BC_VERSION_KEY, version);
    }

    public <T extends Element> VisibilityAndElementMutation<T> updateElementVisibilitySource(Element element, SandboxStatus sandboxStatus, String visibilitySource, String workspaceId, Authorizations authorizations) {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        VisibilityJson visibilityJson = (VisibilityJson)BcSchema.VISIBILITY_JSON.getPropertyValue(element);
        visibilityJson = sandboxStatus != SandboxStatus.PUBLIC ? VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(visibilityJson, visibilitySource, workspaceId) : VisibilityJson.updateVisibilitySource(visibilityJson, visibilitySource);
        BcVisibility bcVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        Visibility visibility = bcVisibility.getVisibility();
        ExistingElementMutation m = element.prepareMutation().alterElementVisibility(visibility);
        if (BcSchema.VISIBILITY_JSON.hasProperty(element)) {
            Property visibilityJsonProperty = BcSchema.VISIBILITY_JSON.getProperty(element);
            m.alterPropertyVisibility(visibilityJsonProperty.getKey(), BcSchema.VISIBILITY_JSON.getPropertyName(), defaultVisibility);
        }
        BcSchema.VISIBILITY_JSON.setProperty(m, visibilityJson, defaultVisibility);
        m.save(authorizations);
        return new VisibilityAndElementMutation(bcVisibility, m);
    }

    public <T extends Element> Property updatePropertyVisibilitySource(Element element, String propertyKey, String propertyName, String oldVisibilitySource, String newVisibilitySource, String workspaceId, User user, Authorizations authorizations) {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        Property property = this.getProperty(element, propertyKey, propertyName, oldVisibilitySource, workspaceId);
        if (property == null) {
            throw new BcResourceNotFoundException("Could not find property " + propertyKey + ":" + propertyName + " on element " + (String)element.getId());
        }
        VisibilityJson newVisibilityJson = new VisibilityJson(newVisibilitySource);
        Visibility newVisibility = this.visibilityTranslator.toVisibility(newVisibilityJson).getVisibility();
        LOGGER.info("%s Altering property visibility %s [%s:%s] from [%s] to [%s]", user.getUserId(), element.getId(), propertyKey, propertyName, oldVisibilitySource, newVisibility.toString());
        ExistingElementMutation m = element.prepareMutation().alterPropertyVisibility(property, newVisibility);
        BcSchema.VISIBILITY_JSON_METADATA.setMetadata(m, property, newVisibilityJson, defaultVisibility);
        Object newElement = m.save(authorizations);
        Property newProperty = newElement.getProperty(propertyKey, propertyName, newVisibility);
        Preconditions.checkNotNull((Object)newProperty, (Object)("Could not find altered property " + propertyKey + ":" + propertyName + " on element " + (String)element.getId()));
        return newProperty;
    }

    private Property getProperty(Element element, String propertyKey, String propertyName, String visibilitySource, String workspaceId) {
        Property property = element.getProperty(propertyKey, propertyName, this.getVisibilityWithWorkspace(visibilitySource, workspaceId));
        if (property == null) {
            property = element.getProperty(propertyKey, propertyName, this.getVisibilityWithWorkspace(visibilitySource, null));
        }
        return property;
    }

    public <T extends Element> VisibilityAndElementMutation<T> setProperty(T element, String propertyName, String propertyKey, Value value, Metadata metadata, String oldVisibilitySource, String newVisibilitySource, String workspaceId, String justificationText, ClientApiSourceInfo sourceInfo, User user, Authorizations authorizations) {
        if (this.autoPublish.booleanValue()) {
            workspaceId = null;
        }
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        Visibility oldPropertyVisibility = this.getVisibilityWithWorkspace(oldVisibilitySource, workspaceId);
        Property oldProperty = element.getProperty(propertyKey, propertyName, oldPropertyVisibility);
        boolean isUpdate = oldProperty != null;
        Metadata propertyMetadata = isUpdate ? oldProperty.getMetadata() : Metadata.create();
        propertyMetadata = GeMetadataUtil.mergeMetadata(propertyMetadata, metadata);
        ExistingElementMutation elementMutation = element.prepareMutation();
        VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, newVisibilitySource, workspaceId);
        BcSchema.VISIBILITY_JSON_METADATA.setMetadata(propertyMetadata, visibilityJson, defaultVisibility);
        BcSchema.MODIFIED_DATE_METADATA.setMetadata(propertyMetadata, ZonedDateTime.now(), defaultVisibility);
        BcSchema.MODIFIED_BY_METADATA.setMetadata(propertyMetadata, user.getUserId(), defaultVisibility);
        BcVisibility bcVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        Visibility propertyVisibility = bcVisibility.getVisibility();
        if (justificationText != null) {
            this.termMentionRepository.removeSourceInfoEdge(element, propertyKey, propertyName, bcVisibility, authorizations);
            BcSchema.JUSTIFICATION_METADATA.setMetadata(propertyMetadata, justificationText, defaultVisibility);
        } else if (sourceInfo != null) {
            Vertex outVertex = this.graph.getVertex(sourceInfo.vertexId, authorizations);
            BcSchema.JUSTIFICATION.removeMetadata(propertyMetadata);
            this.termMentionRepository.addSourceInfo(element, (String)element.getId(), TermMentionFor.PROPERTY, propertyKey, propertyName, propertyVisibility, sourceInfo.snippet, sourceInfo.textPropertyKey, sourceInfo.textPropertyName, sourceInfo.startOffset, sourceInfo.endOffset, outVertex, propertyVisibility, authorizations);
        }
        Property publicProperty = element.getProperty(propertyKey, propertyName);
        if (publicProperty != null && workspaceId != null && SandboxStatus.getFromVisibilityString(publicProperty.getVisibility().getVisibilityString(), workspaceId) == SandboxStatus.PUBLIC) {
            long beforeDeletionTimestamp = System.currentTimeMillis() - 1L;
            element.markPropertyHidden(publicProperty, new Visibility(workspaceId), authorizations);
            this.graph.flush();
            if (this.webQueueRepository.shouldBroadcastGraphPropertyChange(publicProperty.getName(), Priority.HIGH)) {
                this.webQueueRepository.broadcastPropertyChange(element, publicProperty.getKey(), publicProperty.getName(), workspaceId);
            }
            this.workQueueRepository.pushGraphPropertyQueue(element, publicProperty.getKey(), publicProperty.getName(), workspaceId, null, Priority.HIGH, ElementOrPropertyStatus.HIDDEN, beforeDeletionTimestamp);
        } else if (isUpdate && oldVisibilitySource != null && !oldVisibilitySource.equals(newVisibilitySource)) {
            elementMutation.alterPropertyVisibility(oldProperty, propertyVisibility);
        }
        elementMutation.addPropertyValue(propertyKey, propertyName, value, propertyMetadata, propertyVisibility);
        return new VisibilityAndElementMutation(bcVisibility, elementMutation);
    }

    private Visibility getVisibilityWithWorkspace(String visibilitySource, String workspaceId) {
        Visibility visibility = null;
        if (visibilitySource != null) {
            VisibilityJson oldVisibilityJson = new VisibilityJson();
            oldVisibilityJson.setSource(visibilitySource);
            oldVisibilityJson.addWorkspace(workspaceId);
            visibility = this.visibilityTranslator.toVisibility(oldVisibilityJson).getVisibility();
        }
        return visibility;
    }

    public Vertex addVertex(String vertexId, String conceptType, String visibilitySource, String workspaceId, String justificationText, ClientApiSourceInfo sourceInfo, User user, Authorizations authorizations) {
        if (this.autoPublish.booleanValue()) {
            workspaceId = null;
        }
        VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, visibilitySource, workspaceId);
        return this.addVertex(vertexId, conceptType, visibilityJson, justificationText, sourceInfo, user, authorizations);
    }

    public Vertex addVertex(String vertexId, String conceptType, VisibilityJson visibilityJson, String justificationText, ClientApiSourceInfo sourceInfo, User user, Authorizations authorizations) {
        BcVisibility bcVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        VertexBuilder vertexBuilder = vertexId != null ? this.graph.prepareVertex(vertexId, bcVisibility.getVisibility(), conceptType) : this.graph.prepareVertex(bcVisibility.getVisibility(), conceptType);
        this.updateElementMetadataProperties(vertexBuilder, visibilityJson, user);
        boolean justificationAdded = this.addJustification(vertexBuilder, justificationText, bcVisibility, visibilityJson, user);
        Vertex vertex = vertexBuilder.save(authorizations);
        this.graph.flush();
        if (justificationAdded) {
            this.termMentionRepository.removeSourceInfoEdgeFromVertex((String)vertex.getId(), (String)vertex.getId(), null, null, bcVisibility, authorizations);
        } else if (sourceInfo != null) {
            BcSchema.JUSTIFICATION.removeProperty(vertexBuilder, bcVisibility.getVisibility());
            Vertex sourceDataVertex = this.graph.getVertex(sourceInfo.vertexId, authorizations);
            this.termMentionRepository.addSourceInfoToVertex(vertex, (String)vertex.getId(), TermMentionFor.VERTEX, null, null, null, sourceInfo.snippet, sourceInfo.textPropertyKey, sourceInfo.textPropertyName, sourceInfo.startOffset, sourceInfo.endOffset, sourceDataVertex, bcVisibility.getVisibility(), authorizations);
        }
        return vertex;
    }

    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String predicateLabel, String justificationText, ClientApiSourceInfo sourceInfo, String visibilitySource, String workspaceId, User user, Authorizations authorizations) {
        if (this.autoPublish.booleanValue()) {
            workspaceId = null;
        }
        VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, visibilitySource, workspaceId);
        return this.addEdge(edgeId, outVertex, inVertex, predicateLabel, justificationText, sourceInfo, visibilityJson, user, authorizations);
    }

    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String predicateLabel, String justificationText, ClientApiSourceInfo sourceInfo, VisibilityJson visibilityJson, User user, Authorizations authorizations) {
        BcVisibility bcVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        EdgeBuilder edgeBuilder = edgeId == null ? this.graph.prepareEdge(outVertex, inVertex, predicateLabel, bcVisibility.getVisibility()) : this.graph.prepareEdge(edgeId, outVertex, inVertex, predicateLabel, bcVisibility.getVisibility());
        this.updateElementMetadataProperties(edgeBuilder, visibilityJson, user);
        boolean justificationAdded = this.addJustification(edgeBuilder, justificationText, bcVisibility, visibilityJson, user);
        Edge edge = (Edge)edgeBuilder.save(authorizations);
        if (justificationAdded) {
            this.termMentionRepository.removeSourceInfoEdgeFromEdge(edge, null, null, bcVisibility, authorizations);
        } else if (sourceInfo != null) {
            BcSchema.JUSTIFICATION.removeProperty(edgeBuilder, bcVisibility.getVisibility());
            Vertex sourceDataVertex = this.graph.getVertex(sourceInfo.vertexId, authorizations);
            this.termMentionRepository.addSourceInfoEdgeToEdge(edge, (String)edge.getId(), TermMentionFor.EDGE, null, null, null, sourceInfo.snippet, sourceInfo.textPropertyKey, sourceInfo.textPropertyName, sourceInfo.startOffset, sourceInfo.endOffset, sourceDataVertex, bcVisibility.getVisibility(), authorizations);
        }
        return edge;
    }

    private void updateElementMetadataProperties(ElementBuilder elementBuilder, VisibilityJson visibilityJson, User user) {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        BcSchema.VISIBILITY_JSON.setProperty(elementBuilder, visibilityJson, defaultVisibility);
        BcSchema.MODIFIED_DATE.setProperty(elementBuilder, ZonedDateTime.now(), defaultVisibility);
        BcSchema.MODIFIED_BY.setProperty(elementBuilder, user.getUserId(), defaultVisibility);
    }

    private boolean addJustification(ElementBuilder elementBuilder, String justificationText, BcVisibility bcVisibility, VisibilityJson visibilityJson, User user) {
        Visibility visibility = bcVisibility.getVisibility();
        if (justificationText != null) {
            Metadata metadata = Metadata.create();
            Visibility metadataVisibility = this.visibilityTranslator.getDefaultVisibility();
            BcSchema.MODIFIED_DATE_METADATA.setMetadata(metadata, ZonedDateTime.now(), metadataVisibility);
            BcSchema.MODIFIED_BY_METADATA.setMetadata(metadata, user.getUserId(), metadataVisibility);
            BcSchema.VISIBILITY_JSON_METADATA.setMetadata(metadata, visibilityJson, metadataVisibility);
            BcSchema.JUSTIFICATION.setProperty(elementBuilder, justificationText, metadata, visibility);
            return true;
        }
        return false;
    }

    public GraphUpdateContext beginGraphUpdate(Priority priority, User user, Authorizations authorizations) {
        return new MyGraphUpdateContext(this.graph, this.workQueueRepository, this.webQueueRepository, this.visibilityTranslator, priority, user, authorizations);
    }

    private static class MyGraphUpdateContext
    extends GraphUpdateContext {
        protected MyGraphUpdateContext(Graph graph, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, VisibilityTranslator visibilityTranslator, Priority priority, User user, Authorizations authorizations) {
            super(graph, workQueueRepository, webQueueRepository, visibilityTranslator, priority, user, authorizations);
        }
    }
}

