/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.lock;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.exception.BcException;
import com.mware.core.lifecycle.LifeSupportService;
import com.mware.core.model.lock.LeaderListener;
import com.mware.core.model.lock.Lock;
import com.mware.core.model.lock.LockRepository;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;

@Singleton
public class SingleJvmLockRepository
extends LockRepository {
    private WeakHashMap<Long, Thread> threads = new WeakHashMap();

    @VisibleForTesting
    public SingleJvmLockRepository() {
    }

    @Inject
    public SingleJvmLockRepository(LifeSupportService lifeSupportService) {
        lifeSupportService.add(this);
    }

    @Override
    public Lock createLock(String lockName) {
        final Object synchronizationObject = this.getSynchronizationObject(lockName);
        return new Lock(lockName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T run(Callable<T> callable) {
                try {
                    Object object = synchronizationObject;
                    synchronized (object) {
                        return callable.call();
                    }
                }
                catch (Exception ex) {
                    throw new BcException("Failed to run in lock", ex);
                }
            }
        };
    }

    @Override
    public void leaderElection(String lockName, LeaderListener listener) {
        Object synchronizationObject = this.getSynchronizationObject(lockName);
        Thread t = new Thread(() -> {
            Object object = synchronizationObject;
            synchronized (object) {
                try {
                    listener.isLeader();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        t.setName(SingleJvmLockRepository.class.getSimpleName() + "-LeaderElection-" + lockName);
        t.setDaemon(true);
        t.start();
        this.threads.put(t.getId(), t);
    }

    @Override
    public void shutdown() {
        for (Thread thread : this.threads.values()) {
            thread.interrupt();
        }
    }
}

