/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.longRunningProcess;

import com.google.inject.Inject;
import com.mware.core.exception.BcException;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.clientapi.dto.ClientApiSearch;
import com.mware.core.model.longRunningProcess.DeleteRestoreElementsQueueItem;
import com.mware.core.model.longRunningProcess.DeleteRestoreUtil;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.longRunningProcess.LongRunningProcessWorker;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.search.QueryResultsIterableSearchResults;
import com.mware.core.model.search.SearchHelper;
import com.mware.core.model.search.SearchOptions;
import com.mware.core.model.search.SearchRepository;
import com.mware.core.model.search.SearchResults;
import com.mware.core.model.search.SearchRunner;
import com.mware.core.model.user.UserRepository;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementId;
import com.mware.ge.GeObject;
import com.mware.ge.Graph;
import com.mware.ge.GraphBaseWithSearchIndex;
import com.mware.ge.Vertex;
import com.mware.ge.tools.GraphBackup;
import java.io.OutputStream;
import java.util.Map;
import org.json.JSONObject;

@Name(value="Delete Elements")
@Description(value="Delete elements based on a saved search")
public class DeleteElementsLongRunningWorker
extends LongRunningProcessWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(DeleteElementsLongRunningWorker.class);
    protected final AuthorizationRepository authorizationRepository;
    protected final LongRunningProcessRepository longRunningProcessRepository;
    protected final UserRepository userRepository;
    protected final GraphBaseWithSearchIndex graph;
    protected final SearchRepository searchRepository;
    protected final SearchHelper searchHelper;

    @Inject
    public DeleteElementsLongRunningWorker(AuthorizationRepository authorizationRepository, LongRunningProcessRepository longRunningProcessRepository, UserRepository userRepository, Graph graph, SearchRepository searchRepository, SearchHelper searchHelper) {
        this.authorizationRepository = authorizationRepository;
        this.longRunningProcessRepository = longRunningProcessRepository;
        this.userRepository = userRepository;
        this.searchRepository = searchRepository;
        this.searchHelper = searchHelper;
        this.graph = (GraphBaseWithSearchIndex)graph;
    }

    @Override
    public boolean isHandled(JSONObject longRunningProcessQueueItem) {
        return longRunningProcessQueueItem.getString("type").equals("delete-elements");
    }

    @Override
    public void processInternal(JSONObject config) {
        DeleteRestoreElementsQueueItem deleteElements = ClientApiConverter.toClientApi(config.toString(), DeleteRestoreElementsQueueItem.class);
        User user = this.userRepository.findById(deleteElements.getUserId());
        if (user == null) {
            LOGGER.error(String.format("User with id %s not found.", deleteElements.getUserId()), new Object[0]);
            return;
        }
        ClientApiSearch savedSearch = this.searchRepository.getSavedSearch(deleteElements.getSavedSearchId(), user);
        if (savedSearch == null) {
            LOGGER.error(String.format("Saved search with id %s and name %s not found.", deleteElements.getSavedSearchId(), deleteElements.getSavedSearchName()), new Object[0]);
            return;
        }
        Authorizations authorizations = this.authorizationRepository.getGraphAuthorizations(user, new String[0]);
        SearchRunner searchRunner = this.searchRepository.findSearchRunnerByUri(savedSearch.url);
        Map<String, Object> searchParams = savedSearch.prepareParamsForSearch();
        searchParams.put("size", -1);
        long totalhits = 0L;
        SearchOptions searchOptions = new SearchOptions(searchParams, "public-ontology");
        try (SearchResults searchResults = searchRunner.run(searchOptions, user, authorizations);){
            QueryResultsIterableSearchResults geObjectsSearchResults = (QueryResultsIterableSearchResults)searchResults;
            totalhits = geObjectsSearchResults.getQueryResultsIterable().getTotalHits();
            double progress = 0.0;
            if (totalhits <= 0L) {
                throw new BcException("Saved search returned no items.");
            }
            this.longRunningProcessRepository.reportProgress(config, progress += 0.3, String.format("Deleting item 0 of %d", totalhits));
            String backupFile = "N/A";
            if (deleteElements.isBackup()) {
                backupFile = this.backupGraphElements(savedSearch, geObjectsSearchResults);
                this.longRunningProcessRepository.reportProgress(config, progress += 0.5, String.format("Finished running backup, to %s file.", backupFile));
            }
            this.deleteResults(geObjectsSearchResults, authorizations, config, progress, totalhits);
            config.put("backupFile", (Object)backupFile);
            config.put("resultsCount", totalhits);
            this.longRunningProcessRepository.reportProgress(config, 1.0, String.format("Finished running delete for %d items.", totalhits));
        }
        catch (Exception e) {
            throw new BcException(String.format("Job with saved search id %s failed. Error msg : %s", savedSearch.id, e.getMessage()), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String backupGraphElements(ClientApiSearch savedSearch, QueryResultsIterableSearchResults results) {
        String backupFile = DeleteRestoreUtil.getBackupFileName(savedSearch.name);
        GraphBackup backup = this.graph.getBackupTool(backupFile);
        String absolutePath = backup.getAbsoluteFilePath(backupFile);
        LOGGER.info("Backing up to file: %s, using %s tool", absolutePath, backup.getClass().getName());
        try (OutputStream out = backup.createOutputStream();){
            for (GeObject geObject : results.getGeObjects()) {
                if (geObject instanceof Vertex) {
                    backup.saveVertex((Vertex)geObject, out);
                    continue;
                }
                if (!(geObject instanceof Edge)) continue;
                backup.saveEdge((Edge)geObject, out);
            }
            String string = absolutePath;
            return string;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Backup failed for file %s", backupFile), e);
            throw new BcException(e.getMessage());
        }
    }

    private void deleteResults(QueryResultsIterableSearchResults results, Authorizations authorizations, JSONObject config, double progress, long totalHits) {
        double progressUnit = (1.0 - progress) / (double)totalHits;
        int index = 0;
        for (GeObject geObject : results.getQueryResultsIterable()) {
            try {
                if (geObject instanceof Element) {
                    Element element = (Element)geObject;
                    this.graph.deleteElement(ElementId.create(element.getElementType(), (String)element.getId()), authorizations);
                    progress += progressUnit;
                }
                this.longRunningProcessRepository.reportProgress(config, progress, String.format("Deleted %d items of %d", ++index, totalHits));
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), ex);
                throw new BcException(ex.getMessage());
            }
        }
    }
}

