/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.longRunningProcess;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.clientapi.dto.ClientApiVertexFindPathResponse;
import com.mware.core.model.longRunningProcess.FindPathLongRunningProcessQueueItem;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.longRunningProcess.LongRunningProcessWorker;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.FindPathOptions;
import com.mware.ge.Graph;
import com.mware.ge.Path;
import com.mware.ge.ProgressCallback;
import java.util.ArrayList;
import org.json.JSONObject;

@Name(value="Find Path")
@Description(value="Finds a path between two vertices")
@Singleton
public class FindPathLongRunningProcessWorker
extends LongRunningProcessWorker {
    private final Graph graph;
    private final LongRunningProcessRepository longRunningProcessRepository;

    @Inject
    public FindPathLongRunningProcessWorker(Graph graph, LongRunningProcessRepository longRunningProcessRepository) {
        this.graph = graph;
        this.longRunningProcessRepository = longRunningProcessRepository;
    }

    @Override
    public boolean isHandled(JSONObject longRunningProcessQueueItem) {
        return longRunningProcessQueueItem.getString("type").equals("findPath");
    }

    @Override
    public void processInternal(final JSONObject longRunningProcessQueueItem) {
        FindPathLongRunningProcessQueueItem findPath = ClientApiConverter.toClientApi(longRunningProcessQueueItem.toString(), FindPathLongRunningProcessQueueItem.class);
        Authorizations authorizations = this.getAuthorizations(findPath.getAuthorizations());
        String[] labels = findPath.getLabels();
        int hops = findPath.getHops();
        ClientApiVertexFindPathResponse results = new ClientApiVertexFindPathResponse();
        ProgressCallback progressCallback = new ProgressCallback(){

            @Override
            public void progress(double progressPercent, ProgressCallback.Step step, Integer edgeIndex, Integer vertexCount) {
                FindPathLongRunningProcessWorker.this.longRunningProcessRepository.reportProgress(longRunningProcessQueueItem, progressPercent, step.formatMessage(edgeIndex, vertexCount));
            }
        };
        FindPathOptions findPathOptions = new FindPathOptions(findPath.getOutVertexId(), findPath.getInVertexId(), hops).setLabels(labels).setProgressCallback(progressCallback);
        Iterable<Path> paths = this.graph.findPaths(findPathOptions, authorizations);
        for (Path path : paths) {
            ArrayList<String> clientApiVertexPath = new ArrayList<String>();
            for (String s : path) {
                clientApiVertexPath.add(s);
            }
            results.getPaths().add(clientApiVertexPath);
        }
        String resultsString = ClientApiConverter.clientApiToString(results);
        JSONObject resultsJson = new JSONObject(resultsString);
        longRunningProcessQueueItem.put("results", (Object)resultsJson);
        longRunningProcessQueueItem.put("resultsCount", results.getPaths().size());
    }

    private Authorizations getAuthorizations(String[] authorizations) {
        return this.graph.createAuthorizations(authorizations);
    }
}

