/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.longRunningProcess;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.exception.BcException;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.graph.GraphRepository;
import com.mware.core.model.graph.GraphUpdateContext;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.properties.LongRunningProcessSchema;
import com.mware.core.model.properties.types.PropertyMetadata;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.security.BcVisibility;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IterableUtils;
import java.util.List;
import org.json.JSONObject;

@Singleton
public class GeLongRunningProcessRepository
extends LongRunningProcessRepository {
    private final WorkQueueRepository workQueueRepository;
    private final WebQueueRepository webQueueRepository;
    private final GraphRepository graphRepository;
    private final UserRepository userRepository;
    private final Graph graph;
    private final AuthorizationRepository authorizationRepository;

    @Inject
    public GeLongRunningProcessRepository(GraphRepository graphRepository, GraphAuthorizationRepository graphAuthorizationRepository, UserRepository userRepository, WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, Graph graph, AuthorizationRepository authorizationRepository) {
        this.graphRepository = graphRepository;
        this.userRepository = userRepository;
        this.workQueueRepository = workQueueRepository;
        this.webQueueRepository = webQueueRepository;
        this.graph = graph;
        this.authorizationRepository = authorizationRepository;
        graphAuthorizationRepository.addAuthorizationToGraph("longRunningProcess");
    }

    @Override
    public String enqueue(JSONObject longRunningProcessQueueItem, User user, Authorizations authorizations) {
        Object longRunningProcessVertexId;
        Vertex userVertex;
        authorizations = this.getAuthorizations(user);
        if (user instanceof SystemUser) {
            userVertex = null;
        } else {
            userVertex = this.graph.getVertex(user.getUserId(), authorizations);
            Preconditions.checkNotNull((Object)userVertex, (Object)("Could not find user with id: " + user.getUserId()));
        }
        Visibility visibility = this.getVisibility();
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.LOW, user, authorizations);){
            ctx.setPushOnQueue(false);
            longRunningProcessVertexId = ((Vertex)ctx.update(this.graph.prepareVertex(visibility, "__lrp"), elemCtx -> {
                PropertyMetadata metadata = new PropertyMetadata(user, new VisibilityJson(), visibility);
                elemCtx.updateBuiltInProperties(metadata);
                longRunningProcessQueueItem.put("enqueueTime", System.currentTimeMillis());
                longRunningProcessQueueItem.put("userId", (Object)user.getUserId());
                LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.updateProperty(elemCtx, longRunningProcessQueueItem, metadata);
            }).get()).getId();
            if (userVertex != null) {
                ctx.getOrCreateEdgeAndUpdate(null, (String)userVertex.getId(), (String)longRunningProcessVertexId, "__lrpToUsr", visibility, elemCtx -> {});
            }
        }
        catch (Exception ex) {
            throw new BcException("Could not create long running process vertex", ex);
        }
        longRunningProcessQueueItem.put("id", longRunningProcessVertexId);
        this.webQueueRepository.broadcastLongRunningProcessChange(longRunningProcessQueueItem);
        this.workQueueRepository.pushLongRunningProcessQueue(longRunningProcessQueueItem, Priority.NORMAL);
        return longRunningProcessVertexId;
    }

    public Authorizations getAuthorizations(User user) {
        Authorizations authorizations = this.authorizationRepository.getGraphAuthorizations(user, "longRunningProcess", "user");
        return authorizations;
    }

    @Override
    public void beginWork(JSONObject longRunningProcessQueueItem) {
        super.beginWork(longRunningProcessQueueItem);
        this.updateVertexWithJson(longRunningProcessQueueItem);
    }

    @Override
    public void ack(JSONObject longRunningProcessQueueItem) {
        this.updateVertexWithJson(longRunningProcessQueueItem);
    }

    @Override
    public void nak(JSONObject longRunningProcessQueueItem, Throwable ex) {
        this.updateVertexWithJson(longRunningProcessQueueItem);
    }

    public void updateVertexWithJson(JSONObject longRunningProcessQueueItem) {
        String longRunningProcessGraphVertexId = longRunningProcessQueueItem.getString("id");
        Authorizations authorizations = this.getAuthorizations(this.userRepository.getSystemUser());
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.LOW, this.userRepository.getSystemUser(), authorizations);){
            ctx.setPushOnQueue(false);
            Vertex vertex = this.graph.getVertex(longRunningProcessGraphVertexId, authorizations);
            Preconditions.checkNotNull((Object)vertex, (Object)("Could not find long running process vertex: " + longRunningProcessGraphVertexId));
            ctx.update(vertex, elemCtx -> {
                PropertyMetadata metadata = new PropertyMetadata(this.userRepository.getSystemUser(), new VisibilityJson(), this.getVisibility());
                LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.updateProperty(elemCtx, longRunningProcessQueueItem, metadata);
            });
        }
    }

    @Override
    public List<JSONObject> getLongRunningProcesses(User user) {
        Authorizations authorizations = this.getAuthorizations(user);
        Vertex userVertex = this.graph.getVertex(user.getUserId(), authorizations);
        Preconditions.checkNotNull((Object)userVertex, (Object)("Could not find user with id: " + user.getUserId()));
        Iterable<Vertex> longRunningProcessVertices = userVertex.getVertices(Direction.OUT, "__lrpToUsr", authorizations);
        return IterableUtils.toList(new ConvertingIterable<Vertex, JSONObject>(longRunningProcessVertices){

            @Override
            protected JSONObject convert(Vertex longRunningProcessVertex) {
                JSONObject json = (JSONObject)LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.getPropertyValue(longRunningProcessVertex);
                json.put("id", longRunningProcessVertex.getId());
                return json;
            }
        });
    }

    @Override
    public JSONObject findById(String longRunningProcessId, User user) {
        Authorizations authorizations = this.getAuthorizations(user);
        Vertex vertex = this.graph.getVertex(longRunningProcessId, authorizations);
        if (vertex == null) {
            return null;
        }
        return (JSONObject)LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.getPropertyValue(vertex);
    }

    @Override
    public void cancel(String longRunningProcessId, User user) {
        Authorizations authorizations = this.getAuthorizations(this.userRepository.getSystemUser());
        Vertex vertex = this.graph.getVertex(longRunningProcessId, authorizations);
        Preconditions.checkNotNull((Object)vertex, (Object)("Could not find long running process vertex: " + longRunningProcessId));
        JSONObject json = (JSONObject)LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.getPropertyValue(vertex);
        json.put("canceled", true);
        json.put("id", (Object)longRunningProcessId);
        try (GraphUpdateContext ctx = this.graphRepository.beginGraphUpdate(Priority.LOW, user, authorizations);){
            ctx.setPushOnQueue(false);
            VertexBuilder vb = this.graph.prepareVertex(longRunningProcessId, vertex.getVisibility(), "__lrp");
            ctx.update(vb, elemCtx -> {
                PropertyMetadata metadata = new PropertyMetadata(this.userRepository.getSystemUser(), new VisibilityJson(), this.getVisibility());
                LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.updateProperty(elemCtx, json, metadata);
            });
        }
        this.webQueueRepository.broadcastLongRunningProcessChange(json);
    }

    @Override
    public void reportProgress(String longRunningProcessGraphVertexId, double progressPercent, String message) {
        Authorizations authorizations = this.getAuthorizations(this.userRepository.getSystemUser());
        Vertex vertex = this.graph.getVertex(longRunningProcessGraphVertexId, authorizations);
        Preconditions.checkNotNull((Object)vertex, (Object)("Could not find long running process vertex: " + longRunningProcessGraphVertexId));
        JSONObject json = (JSONObject)LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.getPropertyValue(vertex);
        if (json.optBoolean("canceled", false)) {
            throw new BcException("Unable to update progress of cancelled process");
        }
        json.put("progress", progressPercent);
        json.put("progressMessage", (Object)message);
        json.put("id", (Object)longRunningProcessGraphVertexId);
        LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.setProperty(vertex, json, this.getVisibility(), authorizations);
        this.graph.flush();
        this.webQueueRepository.broadcastLongRunningProcessChange(json);
    }

    @Override
    public void delete(String longRunningProcessId, User authUser) {
        Authorizations authorizations = this.getAuthorizations(authUser);
        Vertex vertex = this.graph.getVertex(longRunningProcessId, authorizations);
        JSONObject json = null;
        if (vertex != null) {
            json = (JSONObject)LongRunningProcessSchema.QUEUE_ITEM_JSON_PROPERTY.getPropertyValue(vertex);
        }
        this.graph.deleteVertex(vertex, authorizations);
        this.graph.flush();
        if (json != null) {
            this.webQueueRepository.broadcastLongRunningProcessDeleted(json);
        }
    }

    private Visibility getVisibility() {
        return new BcVisibility("longRunningProcess").getVisibility();
    }
}

