/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.longRunningProcess;

import com.google.inject.Inject;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.model.WorkerBase;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.longRunningProcess.LongRunningProcessWorker;
import com.mware.core.model.longRunningProcess.LongRunningProcessWorkerItem;
import com.mware.core.model.longRunningProcess.LongRunningWorkerPrepareData;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.status.MetricsManager;
import com.mware.core.status.StatusRepository;
import com.mware.core.status.StatusServer;
import com.mware.core.status.model.LongRunningProcessRunnerStatus;
import com.mware.core.status.model.ProcessStatus;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.StoppableRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class LongRunningProcessRunner
extends WorkerBase<LongRunningProcessWorkerItem> {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(LongRunningProcessRunner.class);
    private UserRepository userRepository;
    private LongRunningProcessRepository longRunningProcessRepository;
    private User user;
    private Configuration configuration;
    private List<LongRunningProcessWorker> workers = new ArrayList<LongRunningProcessWorker>();
    private final StatusRepository statusRepository;

    @Inject
    public LongRunningProcessRunner(WorkQueueRepository workQueueRepository, WebQueueRepository webQueueRepository, StatusRepository statusRepository, Configuration configuration, MetricsManager metricsManager) {
        super(workQueueRepository, webQueueRepository, configuration, metricsManager);
        this.statusRepository = statusRepository;
    }

    public void prepare(Map map) {
        this.prepareUser(map);
        this.prepareWorkers(map);
    }

    private void prepareUser(Map map) {
        this.user = (User)map.get("user");
        if (this.user == null) {
            this.user = this.userRepository.getSystemUser();
        }
    }

    private void prepareWorkers(Map map) {
        LongRunningWorkerPrepareData workerPrepareData = new LongRunningWorkerPrepareData(map, this.user, InjectHelper.getInjector());
        Collection<LongRunningProcessWorker> injectedServices = InjectHelper.getInjectedServices(LongRunningProcessWorker.class, this.configuration);
        for (LongRunningProcessWorker worker : injectedServices) {
            try {
                LOGGER.info("preparing: %s", worker.getClass().getName());
                worker.prepare(workerPrepareData);
            }
            catch (Exception ex) {
                throw new BcException("Could not prepare data worker " + worker.getClass().getName(), ex);
            }
            this.workers.add(worker);
        }
    }

    @Override
    protected StatusServer createStatusServer() throws Exception {
        return new StatusServer(this.configuration, this.statusRepository, "longRunningProcess", LongRunningProcessRunner.class){

            @Override
            protected ProcessStatus createStatus() {
                LongRunningProcessRunnerStatus status = new LongRunningProcessRunnerStatus();
                for (LongRunningProcessWorker worker : LongRunningProcessRunner.this.workers) {
                    status.getRunningWorkers().add(worker.getStatus());
                }
                return status;
            }
        };
    }

    @Override
    protected LongRunningProcessWorkerItem tupleDataToWorkerItem(byte[] data) {
        return new LongRunningProcessWorkerItem(data);
    }

    @Override
    public void process(LongRunningProcessWorkerItem workerItem) {
        JSONObject longRunningProcessQueueItem = workerItem.getJson();
        LOGGER.info("Process long running queue item %s", longRunningProcessQueueItem.toString());
        LongRunningProcessWorker worker = this.workers.stream().filter(w -> w.isHandled(longRunningProcessQueueItem)).findFirst().orElse(null);
        if (worker == null) {
            LOGGER.debug("Could not find interested LRP workers.", new Object[0]);
            return;
        }
        try {
            longRunningProcessQueueItem.put("startTime", System.currentTimeMillis());
            longRunningProcessQueueItem.put("progress", 0.0);
            this.longRunningProcessRepository.beginWork(longRunningProcessQueueItem);
            this.getWebQueueRepository().broadcastLongRunningProcessChange(longRunningProcessQueueItem);
            worker.process(longRunningProcessQueueItem);
            longRunningProcessQueueItem.put("endTime", System.currentTimeMillis());
            longRunningProcessQueueItem.put("progress", 1.0);
            this.longRunningProcessRepository.ack(longRunningProcessQueueItem);
            this.getWebQueueRepository().broadcastLongRunningProcessChange(longRunningProcessQueueItem);
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to process long running process queue item", ex);
            longRunningProcessQueueItem.put("error", (Object)ex.getMessage());
            longRunningProcessQueueItem.put("endTime", System.currentTimeMillis());
            this.longRunningProcessRepository.nak(longRunningProcessQueueItem, ex);
            this.getWebQueueRepository().broadcastLongRunningProcessChange(longRunningProcessQueueItem);
        }
    }

    @Override
    protected String getQueueName() {
        return this.configuration.get("lrp.queue.name", "lrpQueue");
    }

    @Inject
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Inject
    public void setLongRunningProcessRepository(LongRunningProcessRepository longRunningProcessRepository) {
        this.longRunningProcessRepository = longRunningProcessRepository;
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public static List<StoppableRunnable> startThreaded(int threadCount, final Configuration config) {
        ArrayList<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();
        LOGGER.info("Starting LongRunningProcessRunners on %d threads", threadCount);
        for (int i = 0; i < threadCount; ++i) {
            StoppableRunnable stoppable = new StoppableRunnable(){
                private LongRunningProcessRunner longRunningProcessRunner = null;

                @Override
                public void run() {
                    try {
                        this.longRunningProcessRunner = InjectHelper.getInstance(LongRunningProcessRunner.class);
                        this.longRunningProcessRunner.prepare(config.toMap());
                        this.longRunningProcessRunner.run();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed running LongRunningProcessRunner", ex);
                    }
                }

                @Override
                public void stop() {
                    try {
                        if (this.longRunningProcessRunner != null) {
                            LOGGER.debug("Stopping LongRunningProcessRunner", new Object[0]);
                            this.longRunningProcessRunner.stop();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed stopping LongRunningProcessRunner", ex);
                    }
                }
            };
            stoppables.add(stoppable);
            Thread t = new Thread(stoppable);
            t.setName("long-running-process-runner-" + t.getId());
            t.setDaemon(true);
            LOGGER.debug("Starting LongRunningProcessRunner thread: %s", t.getName());
            t.start();
        }
        return stoppables;
    }
}

