/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.longRunningProcess;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import com.google.inject.Inject;
import com.mware.core.model.longRunningProcess.LongRunningWorkerPrepareData;
import com.mware.core.status.MetricsManager;
import com.mware.core.status.StatusServer;
import com.mware.core.status.model.LongRunningProcessRunnerStatus;
import com.mware.core.status.model.Status;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import org.json.JSONObject;

public abstract class LongRunningProcessWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(LongRunningProcessWorker.class);
    private MetricsManager metricsManager;
    private Counter totalProcessedCounter;
    private Counter totalErrorCounter;
    private Counter processingCounter;
    private Timer processingTimeTimer;

    public void prepare(LongRunningWorkerPrepareData workerPrepareData) {
        String namePrefix = this.getMetricsManager().getNamePrefix(this);
        this.totalProcessedCounter = this.getMetricsManager().counter(namePrefix + "total-processed");
        this.processingCounter = this.getMetricsManager().counter(namePrefix + "processing");
        this.totalErrorCounter = this.getMetricsManager().counter(namePrefix + "total-errors");
        this.processingTimeTimer = this.getMetricsManager().timer(namePrefix + "processing-time");
    }

    public abstract boolean isHandled(JSONObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(JSONObject longRunningProcessQueueItem) {
        try (Timer.Context t = this.processingTimeTimer.time();){
            this.processingCounter.inc();
            try {
                this.processInternal(longRunningProcessQueueItem);
            }
            finally {
                this.processingCounter.dec();
            }
            this.totalProcessedCounter.inc();
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to complete long running process: " + longRunningProcessQueueItem, ex);
            this.totalErrorCounter.inc();
            throw ex;
        }
    }

    protected abstract void processInternal(JSONObject var1);

    public LongRunningProcessRunnerStatus.LongRunningProcessWorkerStatus getStatus() {
        LongRunningProcessRunnerStatus.LongRunningProcessWorkerStatus status = new LongRunningProcessRunnerStatus.LongRunningProcessWorkerStatus();
        StatusServer.getGeneralInfo(status, this.getClass());
        status.getMetrics().put("totalProcessed", Status.Metric.create((Metric)this.totalProcessedCounter));
        status.getMetrics().put("processing", Status.Metric.create((Metric)this.processingCounter));
        status.getMetrics().put("totalErrors", Status.Metric.create((Metric)this.totalErrorCounter));
        status.getMetrics().put("processingTime", Status.Metric.create((Metric)this.processingTimeTimer));
        return status;
    }

    @Inject
    public final void setMetricsManager(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
    }

    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }
}

