/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.longRunningProcess;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.exception.BcException;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.longRunningProcess.LongRunningProcessWorker;
import com.mware.core.model.longRunningProcess.ReindexLongRunningProcessQueueItem;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.Graph;
import com.mware.ge.GraphWithSearchIndex;
import com.mware.ge.IdRange;
import com.mware.ge.Vertex;
import java.util.ArrayList;
import org.json.JSONObject;

@Name(value="Reindex")
@Description(value="Reindexes the specified elements")
@Singleton
public class ReindexLongRunningProcessWorker
extends LongRunningProcessWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ReindexLongRunningProcessWorker.class);
    private static final FetchHints FETCH_HINTS = FetchHints.ALL;
    private final Authorizations authorizations;
    private final Graph graph;

    @Inject
    public ReindexLongRunningProcessWorker(Graph graph, UserRepository userRepository, AuthorizationRepository authorizationRepository) {
        this.graph = graph;
        this.authorizations = authorizationRepository.getGraphAuthorizations(userRepository.getSystemUser(), new String[0]);
    }

    @Override
    public boolean isHandled(JSONObject jsonObject) {
        return ReindexLongRunningProcessQueueItem.isHandled(jsonObject);
    }

    @Override
    protected void processInternal(JSONObject longRunningProcessQueueItem) {
        ReindexLongRunningProcessQueueItem queueItem = ClientApiConverter.toClientApi(longRunningProcessQueueItem.toString(), ReindexLongRunningProcessQueueItem.class);
        int batchSize = queueItem.getBatchSize();
        IdRange range = new IdRange(queueItem.getStartId(), queueItem.getEndId());
        LOGGER.info("reindex %s %s", new Object[]{range, queueItem.getElementType()});
        if (queueItem.getElementType() == ElementType.VERTEX) {
            this.reindexVertices(range, batchSize, this.authorizations);
        } else if (queueItem.getElementType() == ElementType.EDGE) {
            this.reindexEdges(range, batchSize, this.authorizations);
        } else {
            throw new BcException("Unhandled element type: " + (Object)((Object)queueItem.getElementType()));
        }
    }

    public void reindexVertices(IdRange range, int batchSize, Authorizations authorizations) {
        Iterable<Vertex> vertices = this.graph.getVerticesInRange(range, FETCH_HINTS, authorizations);
        this.reindexElements(vertices, batchSize, authorizations);
    }

    public void reindexEdges(IdRange range, int batchSize, Authorizations authorizations) {
        Iterable<Edge> edges = this.graph.getEdgesInRange(range, FETCH_HINTS, authorizations);
        this.reindexElements(edges, batchSize, authorizations);
    }

    private void reindexElements(Iterable<? extends Element> elements, int batchSize, Authorizations authorizations) {
        ArrayList<Element> batch = new ArrayList<Element>(batchSize);
        for (Element element : elements) {
            batch.add(element);
            if (batch.size() != batchSize) continue;
            ((GraphWithSearchIndex)this.graph).getSearchIndex().addElements(this.graph, batch, authorizations);
            batch.clear();
        }
        if (batch.size() > 0) {
            ((GraphWithSearchIndex)this.graph).getSearchIndex().addElements(this.graph, batch, authorizations);
            batch.clear();
        }
    }
}

