/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.longRunningProcess;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.exception.BcException;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.clientapi.dto.ClientApiSearch;
import com.mware.core.model.longRunningProcess.DeleteRestoreElementsQueueItem;
import com.mware.core.model.longRunningProcess.DeleteRestoreUtil;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.longRunningProcess.LongRunningProcessWorker;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.search.SearchRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;
import com.mware.ge.GraphBaseWithSearchIndex;
import com.mware.ge.tools.GraphRestore;
import java.io.InputStream;
import java.util.Optional;
import org.json.JSONObject;

@Name(value="Restore Elements")
@Description(value="Restore elements based on a saved search backup")
@Singleton
public class RestoreElementsLongRunningWorker
extends LongRunningProcessWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(RestoreElementsLongRunningWorker.class);
    protected final AuthorizationRepository authorizationRepository;
    protected final LongRunningProcessRepository longRunningProcessRepository;
    protected final SearchRepository searchRepository;
    protected final UserRepository userRepository;
    protected final GraphBaseWithSearchIndex graph;

    @Inject
    public RestoreElementsLongRunningWorker(AuthorizationRepository authorizationRepository, LongRunningProcessRepository longRunningProcessRepository, SearchRepository searchRepository, UserRepository userRepository, Graph graph) {
        this.authorizationRepository = authorizationRepository;
        this.longRunningProcessRepository = longRunningProcessRepository;
        this.searchRepository = searchRepository;
        this.userRepository = userRepository;
        this.graph = (GraphBaseWithSearchIndex)graph;
    }

    @Override
    public boolean isHandled(JSONObject longRunningProcessQueueItem) {
        return longRunningProcessQueueItem.getString("type").equals("restore-elements");
    }

    @Override
    public void processInternal(JSONObject config) {
        DeleteRestoreElementsQueueItem deleteElements = ClientApiConverter.toClientApi(config.toString(), DeleteRestoreElementsQueueItem.class);
        User user = this.userRepository.findById(deleteElements.getUserId());
        if (user == null) {
            LOGGER.error(String.format("User with id %s not found.", deleteElements.getUserId()), new Object[0]);
            return;
        }
        ClientApiSearch savedSearch = this.searchRepository.getSavedSearch(deleteElements.getSavedSearchId(), user);
        if (savedSearch == null) {
            LOGGER.error(String.format("Saved search with id %s and name %s not found.", deleteElements.getSavedSearchId(), deleteElements.getSavedSearchName()), new Object[0]);
            return;
        }
        LOGGER.info("Start long running restore elements for user: %s, search: %s, uri: %s", user.getDisplayName(), savedSearch.id, savedSearch.url);
        Authorizations authorizations = this.authorizationRepository.getGraphAuthorizations(user, new String[0]);
        LOGGER.debug("Found authorizations: %s", authorizations);
        this.restoreGraphElements(config, savedSearch, authorizations);
        config.put("restoreComplete", true);
        this.longRunningProcessRepository.reportProgress(config, 1.0, "Finished successfully.");
    }

    private void restoreGraphElements(JSONObject config, ClientApiSearch savedSearch, Authorizations authorizations) {
        long results;
        GraphRestore restore = this.graph.getRestoreTool();
        Optional<String> backupFileName = restore.getLastBackupFile(DeleteRestoreUtil.getBackupFilePrefix(savedSearch.name));
        if (!backupFileName.isPresent()) {
            String msg = String.format("Backup file not found for saved search %s.", savedSearch.name);
            LOGGER.error(msg, new Object[0]);
            throw new BcException(msg);
        }
        String absolutePath = restore.getAbsoluteFilePath(backupFileName.get());
        LOGGER.info("Restoring from backup file: %s, using %s tool", absolutePath, restore.getClass().getName());
        try (InputStream in = restore.createInputStream(backupFileName.get());){
            results = restore.restore(this.graph, in, authorizations, 0L);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            throw new BcException(e.getMessage());
        }
        config.put("backupFile", (Object)absolutePath);
        config.put("resultsCount", results);
    }
}

