/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.longRunningProcess;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.exception.BcException;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.longRunningProcess.LongRunningProcessWorker;
import com.mware.core.model.longRunningProcess.SearchExportLRPQueueItem;
import com.mware.core.model.search.GeObjectSearchRunnerBase;
import com.mware.core.model.search.QueryResultsIterableSearchResults;
import com.mware.core.model.search.SearchOptions;
import com.mware.core.model.search.SearchRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ClientApiConverter;
import com.mware.ge.Authorizations;
import com.mware.ge.GeObject;
import com.mware.ge.Graph;
import com.mware.ge.GraphBaseWithSearchIndex;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.tools.GraphBackup;
import com.mware.ge.tools.GraphToolBase;
import com.mware.ge.values.storable.StreamingPropertyValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@Name(value="Export Raw Search")
@Description(value="Export archive with raw elements from search results")
@Singleton
public class SearchExportLongRunningWorker
extends LongRunningProcessWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(SearchExportLongRunningWorker.class);
    public static final String TYPE = "export-raw-search";
    protected final LongRunningProcessRepository longRunningProcessRepository;
    protected final UserRepository userRepository;
    protected final GraphBaseWithSearchIndex graph;
    protected final SearchRepository searchRepository;

    @Inject
    public SearchExportLongRunningWorker(LongRunningProcessRepository longRunningProcessRepository, UserRepository userRepository, Graph graph, SearchRepository searchRepository) {
        this.longRunningProcessRepository = longRunningProcessRepository;
        this.userRepository = userRepository;
        this.graph = (GraphBaseWithSearchIndex)graph;
        this.searchRepository = searchRepository;
    }

    @Override
    public boolean isHandled(JSONObject longRunningProcessQueueItem) {
        return TYPE.equals(longRunningProcessQueueItem.getString("type"));
    }

    @Override
    public void processInternal(JSONObject config) {
        SearchExportLRPQueueItem queueItem = ClientApiConverter.toClientApi(config.toString(), SearchExportLRPQueueItem.class);
        SearchOptions searchOptions = new SearchOptions(queueItem.getParameters(), queueItem.getWorkspaceId());
        GeObjectSearchRunnerBase searchRunner = (GeObjectSearchRunnerBase)this.searchRepository.findSearchRunnerByUri("/vertex/search");
        User user = this.userRepository.findById(queueItem.getUserId());
        if (user == null) {
            LOGGER.error(String.format("User with id %s not found.", queueItem.getUserId()), new Object[0]);
            return;
        }
        LOGGER.info("Start long running export raw search for user: %s, workspaceId: %s", user.getDisplayName(), queueItem.getWorkspaceId());
        config.put("backupFile", (Object)"Running...");
        try (QueryResultsIterableSearchResults searchResults = searchRunner.run(searchOptions, user, new Authorizations(queueItem.getAuthorizations()));){
            long size = searchResults.getQueryResultsIterable().getTotalHits();
            LOGGER.info("Found %s element(s) for export", size);
            GraphBackup backupTool = this.graph.getBackupTool(null);
            JSONArray export = new JSONArray();
            double progress = 0.0;
            if (size <= 0L) {
                LOGGER.error("Search for raw export returned no items.", new Object[0]);
                throw new BcException("Search for raw export returned no items.");
            }
            this.longRunningProcessRepository.reportProgress(config, progress += 0.3, String.format("Finished running search, found %d item(s).", size));
            long idx = 0L;
            File outputDirectory = new File(this.graph.getBackupDir(), this.archiveFolderName());
            for (GeObject geObject : searchResults.getQueryResultsIterable()) {
                if (geObject instanceof Vertex) {
                    Vertex _vertex = (Vertex)geObject;
                    export.put((Object)backupTool.vertexToJson(_vertex, false));
                    Property fileName = _vertex.getProperty("fileName");
                    Property raw = _vertex.getProperty("raw");
                    if (fileName != null && raw != null) {
                        File outputFile = new File(outputDirectory, fileName.getValue().asObjectCopy().toString());
                        StreamingPropertyValue spv = (StreamingPropertyValue)raw.getValue();
                        FileUtils.copyInputStreamToFile((InputStream)spv.getInputStream(), (File)outputFile);
                    }
                } else {
                    LOGGER.warn("Element of class %s was ignored from export", geObject.getClass().getName());
                }
                this.longRunningProcessRepository.reportProgress(config, progress += 0.7 / (double)size, String.format("Exported %d of %d item(s).", ++idx, size));
            }
            File metaFile = new File(outputDirectory, this.getBackupFileName());
            FileUtils.write((File)metaFile, (CharSequence)export.toString(4));
            String string = this.createZip(this.graph.getBackupDir(), outputDirectory);
            this.deleteFolder(outputDirectory);
            searchResults.getQueryResultsIterable().close();
            config.put("filePath", (Object)string);
            config.put("backupFile", (Object)new File(string).getName());
            config.put("resultsCount", size);
            this.longRunningProcessRepository.reportProgress(config, 1.0, String.format("Finished running export raw search for %d item(s).", size));
        }
        catch (Exception e) {
            LOGGER.error("Export RAW Search failed with message: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
    }

    private String createZip(String path, File directory) {
        try {
            String zipPath = path + File.separator + this.archiveFolderName() + ".zip";
            FileOutputStream fos = new FileOutputStream(zipPath);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            this.zipFile(directory, directory.getName(), zipOut);
            zipOut.close();
            fos.close();
            return zipPath;
        }
        catch (IOException e) {
            LOGGER.error("Could not create zip file. Error message: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    private void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            File[] children = fileToZip.listFiles();
            if (children != null) {
                for (File childFile : children) {
                    this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
                }
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    private void deleteFolder(File directory) {
        String[] entries = directory.list();
        if (entries != null) {
            for (String s : entries) {
                File currentFile = new File(directory.getPath(), s);
                for (int retries = 3; !currentFile.delete() && retries > 0; --retries) {
                }
            }
        }
        for (int retries = 3; !directory.delete() && retries > 0; --retries) {
        }
    }

    private String getBackupFileName() {
        return "search_export.ge";
    }

    private String archiveFolderName() {
        return LocalDateTime.now().format(GraphToolBase.BACKUP_DATETIME_FORMATTER);
    }
}

