/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.mware.core.exception.BcException;
import com.mware.core.model.notification.ExpirationAgeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpirationAge {
    private int amount;
    private ExpirationAgeUnit expirationAgeUnit;

    public ExpirationAge(int amount, ExpirationAgeUnit expirationAgeUnit) {
        this.amount = amount;
        this.expirationAgeUnit = expirationAgeUnit;
    }

    public int getAmount() {
        return this.amount;
    }

    public ExpirationAgeUnit getExpirationAgeUnit() {
        return this.expirationAgeUnit;
    }

    public String toString() {
        return this.getAmount() + this.getExpirationAgeUnit().getAbbreviation();
    }

    public static ExpirationAge parse(String value) {
        Matcher m = Pattern.compile("([0-9]+)(.)").matcher(value);
        if (!m.matches()) {
            throw new BcException("Could not parse " + ExpirationAge.class.getSimpleName() + ": " + value);
        }
        return new ExpirationAge(Integer.parseInt(m.group(1)), ExpirationAgeUnit.parse(m.group(2)));
    }
}

