/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.model.notification.SystemNotification;
import com.mware.core.model.notification.SystemNotificationRepository;
import com.mware.core.model.notification.SystemNotificationSeverity;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.user.User;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;

@Singleton
public class InMemorySystemNotificationRepository
extends SystemNotificationRepository {
    private final Map<String, SystemNotification> notifications = new HashMap<String, SystemNotification>();

    @Inject
    public InMemorySystemNotificationRepository(SimpleOrmSession simpleOrmSession) {
        super(simpleOrmSession);
    }

    @Override
    public List<SystemNotification> getActiveNotifications(User user) {
        Date now = new Date();
        return this.notifications.values().stream().filter(n -> n.getStartDate().compareTo(now) <= 0 && (n.getEndDate() == null || n.getEndDate().compareTo(now) >= 0)).sorted(Comparator.comparing(SystemNotification::getStartDate)).collect(Collectors.toList());
    }

    @Override
    public SystemNotification createNotification(SystemNotificationSeverity severity, String title, String message, String actionEvent, JSONObject actionPayload, Date startDate, Date endDate, User user) {
        if (startDate == null) {
            startDate = new Date();
        }
        SystemNotification notification = new SystemNotification(startDate, title, message, actionEvent, actionPayload);
        notification.setSeverity(severity);
        notification.setStartDate(startDate);
        notification.setEndDate(endDate);
        return this.updateNotification(notification, user);
    }

    @Override
    public SystemNotification getNotification(String id, User user) {
        return this.notifications.get(id);
    }

    @Override
    public SystemNotification updateNotification(SystemNotification notification, User user) {
        this.notifications.put(notification.getId(), notification);
        return notification;
    }

    @Override
    public void clearNotifications() {
        this.notifications.clear();
    }

    @Override
    public List<SystemNotification> getFutureNotifications(Date maxDate, User user) {
        Date now = new Date();
        return this.notifications.values().stream().filter(n -> n.getStartDate().compareTo(now) >= 0 && (n.getEndDate() == null || n.getEndDate().compareTo(maxDate) <= 0)).sorted(Comparator.comparing(SystemNotification::getStartDate)).collect(Collectors.toList());
    }
}

