/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.model.notification.ExpirationAge;
import com.mware.core.model.notification.UserNotification;
import com.mware.core.model.notification.UserNotificationRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.user.User;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.json.JSONObject;

@Singleton
public class InMemoryUserNotificationRepository
extends UserNotificationRepository {
    private Map<String, UserNotification> notifications = new HashMap<String, UserNotification>();
    private WebQueueRepository webQueueRepository;

    @Inject
    public InMemoryUserNotificationRepository(SimpleOrmSession simpleOrmSession, WebQueueRepository webQueueRepository) {
        super(simpleOrmSession, webQueueRepository);
        this.webQueueRepository = webQueueRepository;
    }

    @Override
    public Stream<UserNotification> findAll(User authUser) {
        return this.notifications.values().stream().sorted(Comparator.comparing(UserNotification::getSentDate));
    }

    @Override
    public void saveNotification(UserNotification notification, User authUser) {
        this.notifications.put(notification.getId(), notification);
        this.webQueueRepository.pushUserNotification(notification);
    }

    @Override
    public UserNotification getNotification(String id, User user) {
        return this.notifications.get(id);
    }

    @Override
    public void markRead(String[] notificationIds, User user) {
        for (String notificationId : notificationIds) {
            this.notifications.get(notificationId).setMarkedRead(true);
        }
    }

    @Override
    public void markNotified(Iterable<String> notificationIds, User user) {
        for (String notificationId : notificationIds) {
            this.notifications.get(notificationId).setNotified(true);
        }
    }

    public UserNotification createNotification(String userId, String title, String message, String actionEvent, JSONObject actionPayload, Date sentTime, ExpirationAge expirationAge, User authUser) {
        UserNotification notification = new UserNotification(userId, title, message, actionEvent, actionPayload, sentTime, expirationAge);
        this.saveNotification(notification, authUser);
        return notification;
    }
}

