/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.mware.core.exception.BcException;
import com.mware.core.orm.Field;
import com.mware.core.orm.Id;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.json.JSONObject;

public abstract class Notification {
    public static final String ACTION_EVENT_EXTERNAL_URL = "EXTERNAL_URL";
    public static final String ACTION_EVENT_OBJECT_ID = "OBJECT_ID";
    @Id
    private String id;
    @Field
    private String title;
    @Field
    private String message;
    @Field
    private String actionEvent;
    @Field
    private JSONObject actionPayload;

    protected Notification(String id, String title, String message, String actionEvent, JSONObject actionPayload) {
        this.id = id;
        this.title = title;
        this.message = message;
        this.actionEvent = actionEvent;
        this.actionPayload = actionPayload;
    }

    protected Notification() {
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getActionEvent() {
        return this.actionEvent;
    }

    public void setActionEvent(String actionEvent) {
        this.actionEvent = actionEvent;
    }

    public JSONObject getActionPayload() {
        return this.actionPayload;
    }

    public void setActionPayload(JSONObject actionPayload) {
        this.actionPayload = actionPayload;
    }

    public void setExternalUrl(String externalUrl) {
        if (this.getActionPayload() != null || this.getActionEvent() != null) {
            throw new IllegalStateException("actionPayload or actionEvent is already assigned");
        }
        this.setActionEvent(ACTION_EVENT_EXTERNAL_URL);
        JSONObject payload = new JSONObject();
        payload.put("url", (Object)externalUrl);
        this.setActionPayload(payload);
    }

    public void setElementId(String id) {
        if (this.getActionPayload() != null || this.getActionEvent() != null) {
            throw new IllegalStateException("actionPayload or actionEvent is already assigned");
        }
        this.setActionEvent(ACTION_EVENT_OBJECT_ID);
        JSONObject payload = new JSONObject();
        payload.put("eid", (Object)id);
        this.setActionPayload(payload);
    }

    public final JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("title", (Object)this.getTitle());
        json.put("type", (Object)this.getType());
        json.put("message", (Object)this.getMessage());
        json.put("actionEvent", (Object)this.getActionEvent());
        json.put("actionPayload", (Object)this.getActionPayload());
        this.populateJSONObject(json);
        json.put("hash", (Object)Notification.hashJson(json));
        return json;
    }

    protected abstract void populateJSONObject(JSONObject var1);

    protected abstract String getType();

    private static String hashJson(JSONObject json) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] md5 = digest.digest(json.toString().getBytes());
            return Hex.encodeHexString((byte[])md5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BcException("Could not find MD5", e);
        }
    }
}

