/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.mware.core.model.notification.Notification;
import com.mware.core.model.notification.SystemNotificationSeverity;
import com.mware.core.orm.Entity;
import com.mware.core.orm.Field;
import java.util.Date;
import java.util.UUID;
import org.json.JSONObject;

@Entity(tableName="systemNotifications")
public class SystemNotification
extends Notification {
    @Field
    private SystemNotificationSeverity severity;
    @Field
    private Date startDate;
    @Field
    private Date endDate;

    protected SystemNotification() {
    }

    SystemNotification(Date startDate, String title, String message, String actionEvent, JSONObject actionPayload) {
        super(SystemNotification.createId(startDate), title, message, actionEvent, actionPayload);
    }

    private static String createId(Date startDate) {
        return Long.toString(startDate.getTime()) + ":" + UUID.randomUUID().toString();
    }

    public SystemNotificationSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(SystemNotificationSeverity severity) {
        this.severity = severity;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        if (startDate == null) {
            startDate = new Date();
        }
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isActive() {
        Date now = new Date();
        Date endDate = this.getEndDate();
        return this.getStartDate().before(now) && (endDate == null || endDate.after(now));
    }

    @Override
    protected String getType() {
        return "system";
    }

    @Override
    public void populateJSONObject(JSONObject json) {
        Date endDate;
        json.put("severity", (Object)this.getSeverity());
        Date startDate = this.getStartDate();
        if (startDate != null) {
            json.put("startDate", startDate.getTime());
        }
        if ((endDate = this.getEndDate()) != null) {
            json.put("endDate", endDate.getTime());
        }
    }
}

