/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.model.notification.NotificationRepository;
import com.mware.core.model.notification.SystemNotification;
import com.mware.core.model.notification.SystemNotificationSeverity;
import com.mware.core.model.user.UserRepository;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

@Singleton
public class SystemNotificationRepository
extends NotificationRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(SystemNotificationRepository.class);
    private static final String VISIBILITY_STRING = "";
    private UserRepository userRepository;

    @Inject
    public SystemNotificationRepository(SimpleOrmSession simpleOrmSession) {
        super(simpleOrmSession);
    }

    public void clearNotifications() {
        SimpleOrmContext ctx = this.getUserRepository().getSimpleOrmContext("administrator");
        for (SystemNotification notification : this.getSimpleOrmSession().findAll(SystemNotification.class, ctx)) {
            this.getSimpleOrmSession().delete(SystemNotification.class, notification.getId(), ctx);
        }
    }

    public List<SystemNotification> getActiveNotifications(User user) {
        Date now = new Date();
        ArrayList<SystemNotification> activeNotifications = new ArrayList<SystemNotification>();
        SimpleOrmContext ctx = this.getUserRepository().getSimpleOrmContext("administrator");
        for (SystemNotification notification : this.getSimpleOrmSession().findAll(SystemNotification.class, ctx)) {
            if (!notification.getStartDate().before(now) || notification.getEndDate() != null && !notification.getEndDate().after(now)) continue;
            activeNotifications.add(notification);
        }
        LOGGER.debug("returning %d active system notifications", activeNotifications.size());
        return activeNotifications;
    }

    public SystemNotification createNotification(SystemNotificationSeverity severity, String title, String message, String actionEvent, JSONObject actionPayload, Date startDate, Date endDate, User user) {
        if (startDate == null) {
            startDate = new Date();
        }
        SystemNotification notification = new SystemNotification(startDate, title, message, actionEvent, actionPayload);
        notification.setSeverity(severity);
        notification.setStartDate(startDate);
        notification.setEndDate(endDate);
        this.getSimpleOrmSession().save(notification, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext("administrator"));
        return notification;
    }

    public SystemNotification createNotification(SystemNotificationSeverity severity, String title, String message, String externalUrl, Date startDate, Date endDate, User user) {
        String actionEvent = null;
        JSONObject actionPayload = null;
        if (externalUrl != null) {
            actionEvent = "EXTERNAL_URL";
            actionPayload = new JSONObject();
            actionPayload.put("url", (Object)externalUrl);
        }
        return this.createNotification(severity, title, message, actionEvent, actionPayload, startDate, endDate, user);
    }

    public SystemNotification getNotification(String rowKey, User user) {
        return this.getSimpleOrmSession().findById(SystemNotification.class, rowKey, this.getUserRepository().getSimpleOrmContext("administrator"));
    }

    public SystemNotification updateNotification(SystemNotification notification, User user) {
        this.getSimpleOrmSession().save(notification, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext("administrator"));
        return notification;
    }

    public void endNotification(SystemNotification notification, User user) {
        notification.setEndDate(new Date());
        this.updateNotification(notification, user);
    }

    public List<SystemNotification> getFutureNotifications(Date maxDate, User user) {
        Date now = new Date();
        ArrayList<SystemNotification> futureNotifications = new ArrayList<SystemNotification>();
        for (SystemNotification notification : this.getSimpleOrmSession().findAll(SystemNotification.class, this.getUserRepository().getSimpleOrmContext("administrator"))) {
            if (!notification.getStartDate().after(now) || !notification.getStartDate().before(maxDate)) continue;
            futureNotifications.add(notification);
        }
        LOGGER.debug("returning %d future system notifications", futureNotifications.size());
        return futureNotifications;
    }

    public UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }
}

