/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configuration;
import com.mware.core.lifecycle.LifeSupportService;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.notification.SystemNotificationRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.util.PeriodicBackgroundService;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

@Singleton
public class SystemNotificationService
extends PeriodicBackgroundService {
    private static final Integer CHECK_INTERVAL_SECONDS_DEFAULT = 60;
    private static final String CHECK_INTERVAL_CONFIG_NAME = SystemNotificationService.class.getName() + ".checkIntervalSeconds";
    private final UserRepository userRepository;
    private final Integer checkIntervalSeconds;
    private final WebQueueRepository webQueueRepository;
    private final SystemNotificationRepository systemNotificationRepository;

    @Inject
    public SystemNotificationService(Configuration configuration, UserRepository userRepository, LockRepository lockRepository, WebQueueRepository webQueueRepository, SystemNotificationRepository systemNotificationRepository, LifeSupportService lifeSupportService) {
        super(lockRepository);
        this.userRepository = userRepository;
        this.checkIntervalSeconds = configuration.getInt(CHECK_INTERVAL_CONFIG_NAME, CHECK_INTERVAL_SECONDS_DEFAULT);
        this.webQueueRepository = webQueueRepository;
        this.systemNotificationRepository = systemNotificationRepository;
        lifeSupportService.add(this);
    }

    @Override
    protected void run() {
        Date now = new Date();
        Date nowPlusOneMinute = DateUtils.addSeconds((Date)now, (int)this.getCheckIntervalSeconds());
        this.systemNotificationRepository.getFutureNotifications(nowPlusOneMinute, this.userRepository.getSystemUser()).forEach(this.webQueueRepository::pushSystemNotification);
    }

    @Override
    protected int getCheckIntervalSeconds() {
        return this.checkIntervalSeconds;
    }
}

