/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.google.common.annotations.VisibleForTesting;
import com.mware.core.model.notification.ExpirationAge;
import com.mware.core.model.notification.ExpirationAgeUnit;
import com.mware.core.model.notification.Notification;
import com.mware.core.orm.Entity;
import com.mware.core.orm.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONObject;

@Entity(tableName="userNotifications")
public class UserNotification
extends Notification {
    @Field
    private String userId;
    @Field
    private Date sentDate;
    @Field
    private Integer expirationAgeAmount;
    @Field
    private ExpirationAgeUnit expirationAgeUnit;
    @Field
    private boolean markedRead;
    @Field
    private boolean notified;

    protected UserNotification() {
    }

    @VisibleForTesting
    public UserNotification(String userId, String title, String message, String actionEvent, JSONObject actionPayload, ExpirationAge expirationAge) {
        this(userId, title, message, actionEvent, actionPayload, new Date(), expirationAge);
    }

    @VisibleForTesting
    public UserNotification(String userId, String title, String message, String actionEvent, JSONObject actionPayload, Date sentDate, ExpirationAge expirationAge) {
        super(UserNotification.createRowKey(sentDate), title, message, actionEvent, actionPayload);
        this.userId = userId;
        this.sentDate = sentDate;
        this.markedRead = false;
        this.notified = false;
        if (expirationAge != null) {
            this.expirationAgeAmount = expirationAge.getAmount();
            this.expirationAgeUnit = expirationAge.getExpirationAgeUnit();
        }
    }

    private static String createRowKey(Date date) {
        return Long.toString(date.getTime()) + ":" + UUID.randomUUID().toString();
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public ExpirationAge getExpirationAge() {
        if (this.expirationAgeUnit != null && this.expirationAgeAmount != null) {
            return new ExpirationAge(this.expirationAgeAmount, this.expirationAgeUnit);
        }
        return null;
    }

    public boolean isMarkedRead() {
        return this.markedRead;
    }

    public void setMarkedRead(boolean markedRead) {
        this.markedRead = markedRead;
    }

    public boolean isNotified() {
        return this.notified;
    }

    public void setNotified(boolean notified) {
        this.notified = notified;
    }

    public boolean isActive() {
        if (this.isMarkedRead()) {
            return false;
        }
        Date now = new Date();
        Date expirationDate = this.getExpirationDate();
        Date sentDate = this.getSentDate();
        return sentDate.before(now) && (expirationDate == null || expirationDate.after(now));
    }

    public Date getExpirationDate() {
        ExpirationAge age = this.getExpirationAge();
        if (age == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(this.getSentDate());
        ((Calendar)cal).add(age.getExpirationAgeUnit().getCalendarUnit(), age.getAmount());
        return cal.getTime();
    }

    @Override
    protected String getType() {
        return "user";
    }

    @Override
    public void populateJSONObject(JSONObject json) {
        json.put("userId", (Object)this.getUserId());
        json.put("sentDate", (Object)this.getSentDate());
        json.put("expirationAge", (Object)this.getExpirationAge());
        json.put("markedRead", this.isMarkedRead());
        json.put("notified", this.isNotified());
    }

    public String toString() {
        return "UserNotification{userId='" + this.userId + '\'' + ", title=" + this.getTitle() + ", sentDate=" + this.sentDate + ", expirationAgeAmount=" + this.expirationAgeAmount + ", expirationAgeUnit=" + (Object)((Object)this.expirationAgeUnit) + ", markedRead=" + this.markedRead + ", notified=" + this.notified + '}';
    }
}

