/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.notification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.model.notification.ExpirationAge;
import com.mware.core.model.notification.NotificationRepository;
import com.mware.core.model.notification.UserNotification;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.user.User;
import com.mware.core.util.StreamUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.json.JSONObject;

@Singleton
public class UserNotificationRepository
extends NotificationRepository {
    private static final String VISIBILITY_STRING = "";
    private final WebQueueRepository webQueueRepository;
    private UserRepository userRepository;

    @Inject
    public UserNotificationRepository(SimpleOrmSession simpleOrmSession, WebQueueRepository webQueueRepository) {
        super(simpleOrmSession);
        this.webQueueRepository = webQueueRepository;
    }

    @VisibleForTesting
    public UserNotificationRepository(SimpleOrmSession simpleOrmSession, WebQueueRepository webQueueRepository, UserRepository userRepository) {
        this(simpleOrmSession, webQueueRepository);
        this.userRepository = userRepository;
    }

    public Stream<UserNotification> getActiveNotifications(User user) {
        Date now = new Date();
        return this.findAll(user).filter(notification -> user.getUserId().equals(notification.getUserId()) && notification.getSentDate().before(now) && notification.isActive());
    }

    public Stream<UserNotification> findAll(User user) {
        SimpleOrmContext ctx = this.getUserRepository().getSimpleOrmContext(user);
        return StreamUtil.stream(this.getSimpleOrmSession().findAll(UserNotification.class, ctx));
    }

    public Stream<UserNotification> getActiveNotificationsOlderThan(int duration, TimeUnit timeUnit, User user) {
        Date now = new Date();
        return this.findAll(user).filter(notification -> {
            if (!notification.isActive()) {
                return false;
            }
            Date t = new Date(notification.getSentDate().getTime() + timeUnit.toMillis(duration));
            return t.before(now);
        });
    }

    public UserNotification createNotification(String userId, String title, String message, String actionEvent, JSONObject actionPayload, ExpirationAge expirationAge, User authUser) {
        UserNotification notification = new UserNotification(userId, title, message, actionEvent, actionPayload, expirationAge);
        this.saveNotification(notification, authUser);
        return notification;
    }

    public UserNotification createNotification(String userId, String title, String message, String externalUrl, ExpirationAge expirationAge, User authUser) {
        UserNotification notification = new UserNotification(userId, title, message, null, null, expirationAge);
        notification.setExternalUrl(externalUrl);
        this.saveNotification(notification, authUser);
        return notification;
    }

    public void saveNotification(UserNotification notification, User authUser) {
        this.getSimpleOrmSession().save(notification, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext("administrator"));
        this.webQueueRepository.pushUserNotification(notification);
    }

    public UserNotification getNotification(String notificationId, User user) {
        return this.getSimpleOrmSession().findById(UserNotification.class, notificationId, this.getUserRepository().getSimpleOrmContext("administrator"));
    }

    public void markRead(String[] notificationIds, User user) {
        ArrayList<UserNotification> toSave = new ArrayList<UserNotification>();
        for (String notificationId : notificationIds) {
            UserNotification notification = this.getNotification(notificationId, user);
            Preconditions.checkNotNull((Object)notification, (Object)("Could not find notification with id " + notificationId));
            notification.setMarkedRead(true);
            toSave.add(notification);
        }
        this.getSimpleOrmSession().saveMany(toSave, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext("administrator"));
    }

    public void markNotified(Iterable<String> notificationIds, User user) {
        ArrayList<UserNotification> toSave = new ArrayList<UserNotification>();
        for (String notificationId : notificationIds) {
            UserNotification notification = this.getNotification(notificationId, user);
            Preconditions.checkNotNull((Object)notification, (Object)("Could not find notification with id " + notificationId));
            notification.setNotified(true);
            toSave.add(notification);
        }
        this.getSimpleOrmSession().saveMany(toSave, VISIBILITY_STRING, this.getUserRepository().getSimpleOrmContext("administrator"));
    }

    public UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }
}

