/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.properties;

import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class ArtifactDetectedObject {
    private final String edgeId;
    private final String resolvedVertexId;
    private final String originalPropertyKey;
    private String concept;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private String process;

    public ArtifactDetectedObject(JSONObject json) {
        this.x1 = json.getDouble("x1");
        this.y1 = json.getDouble("y1");
        this.x2 = json.getDouble("x2");
        this.y2 = json.getDouble("y2");
        this.process = json.optString("process");
        this.concept = json.optString("concept");
        this.edgeId = json.optString("edgeId");
        this.resolvedVertexId = json.optString("resolvedVertexId");
        this.originalPropertyKey = json.optString("originalPropertyKey");
    }

    public ArtifactDetectedObject(double x1, double y1, double x2, double y2, String concept, String process, String edgeId, String resolvedVertexId, String originalPropertyKey) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.concept = concept;
        this.process = process;
        this.edgeId = edgeId;
        this.resolvedVertexId = resolvedVertexId;
        this.originalPropertyKey = originalPropertyKey;
    }

    public ArtifactDetectedObject(double x1, double y1, double x2, double y2, String concept, String process) {
        this(x1, y1, x2, y2, concept, process, null, null, null);
    }

    public double getX1() {
        return this.x1;
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public double getY1() {
        return this.y1;
    }

    public void setY1(double y1) {
        this.y1 = y1;
    }

    public double getX2() {
        return this.x2;
    }

    public void setX2(double x2) {
        this.x2 = x2;
    }

    public double getY2() {
        return this.y2;
    }

    public void setY2(double y2) {
        this.y2 = y2;
    }

    public String getConcept() {
        return this.concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    public String getResolvedVertexId() {
        return this.resolvedVertexId;
    }

    public String getOriginalPropertyKey() {
        return this.originalPropertyKey;
    }

    public String getMultivalueKey(String multiValueKeyPrefix) {
        return multiValueKeyPrefix + ":" + StringUtils.leftPad((String)Double.toString(this.getX1()), (int)16, (char)'0') + ":" + StringUtils.leftPad((String)Double.toString(this.getY1()), (int)16, (char)'0') + ":" + StringUtils.leftPad((String)Double.toString(this.getX2()), (int)16, (char)'0') + ":" + StringUtils.leftPad((String)Double.toString(this.getY2()), (int)16, (char)'0');
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("x1", this.getX1());
        json.put("y1", this.getY1());
        json.put("x2", this.getX2());
        json.put("y2", this.getY2());
        if (this.getProcess() != null) {
            json.put("process", (Object)this.getProcess());
        }
        if (this.getConcept() != null) {
            json.put("concept", (Object)this.getConcept());
        }
        if (this.getEdgeId() != null) {
            json.put("edgeId", (Object)this.getEdgeId());
        }
        if (this.getResolvedVertexId() != null) {
            json.put("resolvedVertexId", (Object)this.getResolvedVertexId());
        }
        if (this.getOriginalPropertyKey() != null) {
            json.put("originalPropertyKey", (Object)this.getOriginalPropertyKey());
        }
        return json;
    }
}

