/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.properties.types;

import com.google.common.base.Preconditions;
import com.mware.core.model.graph.ElementUpdateContext;
import com.mware.core.model.properties.types.PropertyMetadata;
import com.mware.ge.Element;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.values.storable.NoValue;
import com.mware.ge.values.storable.Value;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BcExtendedData<TRaw> {
    private static final String ROW_ID_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private final String tableName;
    private final String columnName;

    protected BcExtendedData(String tableName, String columnName) {
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public abstract Value rawToGraph(TRaw var1);

    public abstract TRaw graphToRaw(Value var1);

    public <T extends Element> void addExtendedData(ElementUpdateContext<T> elemCtx, String row, TRaw newValue, PropertyMetadata propertyMetadata) {
        this.addExtendedData(elemCtx.getMutation(), row, newValue, propertyMetadata);
    }

    public <T extends Element> void addExtendedData(ElementUpdateContext<T> elemCtx, String row, TRaw newValue, PropertyMetadata propertyMetadata, Long timestamp) {
        this.addExtendedData(elemCtx.getMutation(), row, newValue, propertyMetadata, timestamp);
    }

    public <T extends Element> void addExtendedData(ElementMutation<T> m, String row, TRaw newValue, PropertyMetadata propertyMetadata) {
        this.addExtendedData(m, row, newValue, propertyMetadata, null);
    }

    public <T extends Element> void addExtendedData(ElementMutation<T> m, String row, TRaw newValue, PropertyMetadata propertyMetadata, Long timestamp) {
        Preconditions.checkNotNull(newValue, (Object)"null values are not allowed");
        m.addExtendedData(this.tableName, row, this.columnName, this.rawToGraph(newValue), timestamp, propertyMetadata.getPropertyVisibility());
    }

    public static String rowIdFromDate(Date timestamp) {
        return new SimpleDateFormat(ROW_ID_DATE_FORMAT).format(timestamp);
    }

    public TRaw getValue(ExtendedDataRow row) {
        Value value = row.getPropertyValue(this.columnName);
        if (value == null || value instanceof NoValue) {
            return null;
        }
        return this.graphToRaw(value);
    }
}

