/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.properties.types;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mware.ge.Property;
import com.mware.ge.values.storable.Value;

public abstract class BcPropertyBase<TRaw> {
    private final String propertyName;
    private final Function<Value, TRaw> rawConverter;

    protected BcPropertyBase(String propertyName) {
        this.propertyName = propertyName;
        this.rawConverter = new RawConverter();
    }

    public abstract Value wrap(TRaw var1);

    public abstract TRaw unwrap(Value var1);

    public final String getPropertyName() {
        return this.propertyName;
    }

    public boolean isSameName(Property property) {
        return this.isSameName(property.getName());
    }

    public boolean isSameName(String propertyName) {
        return this.propertyName.equals(propertyName);
    }

    protected Function<Value, TRaw> getRawConverter() {
        return this.rawConverter;
    }

    public TRaw getPropertyValue(Property property) {
        return this.unwrap(property.getValue());
    }

    protected boolean isEquals(TRaw newValue, TRaw currentValue) {
        Preconditions.checkNotNull(newValue, (Object)"newValue cannot be null");
        Preconditions.checkNotNull(currentValue, (Object)"currentValue cannot be null");
        return newValue.equals(currentValue);
    }

    public String toString() {
        return this.getClass().getName() + "{propertyName='" + this.propertyName + "'}";
    }

    protected class RawConverter
    implements Function<Value, TRaw> {
        protected RawConverter() {
        }

        public TRaw apply(Value input) {
            return BcPropertyBase.this.unwrap(input);
        }
    }
}

