/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.properties.types;

import com.mware.core.model.graph.ElementUpdateContext;
import com.mware.core.model.properties.types.BcProperty;
import com.mware.core.model.properties.types.PropertyMetadata;
import com.mware.ge.Element;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.NoValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class DateBcProperty
extends BcProperty<ZonedDateTime> {
    public DateBcProperty(String key) {
        super(key);
    }

    @Override
    public Value wrap(ZonedDateTime value) {
        return Values.of(value);
    }

    @Override
    public ZonedDateTime unwrap(Value value) {
        if (value == null || value instanceof NoValue) {
            return null;
        }
        return (ZonedDateTime)((DateTimeValue)value).asObjectCopy();
    }

    @Override
    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, String propertyKey, OffsetDateTime newValue, PropertyMetadata metadata) {
        this.updateProperty(ctx, propertyKey, newValue, metadata, (Long)null);
    }

    @Override
    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, String propertyKey, OffsetDateTime newValue, PropertyMetadata metadata, Long timestamp) {
        ZonedDateTime date = newValue == null ? null : ZonedDateTime.from(newValue.toInstant());
        this.updateProperty(ctx, propertyKey, date, metadata, timestamp);
    }

    @Override
    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, String propertyKey, ZonedDateTime newValue, PropertyMetadata metadata) {
        this.updateProperty(ctx, propertyKey, newValue, metadata, (Long)null);
    }

    @Override
    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, String propertyKey, ZonedDateTime newValue, PropertyMetadata metadata, Long timestamp) {
        ZonedDateTime date = newValue == null ? null : ZonedDateTime.from(newValue.toInstant());
        this.updateProperty(ctx, propertyKey, date, metadata, timestamp);
    }

    public <T extends Element> void updatePropertyIfValueIsNewer(ElementUpdateContext<T> ctx, String propertyKey, ZonedDateTime newValue, PropertyMetadata metadata, Long timestamp) {
        if (this.isDateNewer(ctx.getElement(), propertyKey, newValue)) {
            this.updateProperty(ctx, propertyKey, newValue, metadata, timestamp);
        }
    }

    public <T extends Element> void updatePropertyIfValueIsNewer(ElementUpdateContext<T> ctx, String propertyKey, ZonedDateTime newValue, PropertyMetadata metadata) {
        if (this.isDateNewer(ctx.getElement(), propertyKey, newValue)) {
            this.updateProperty(ctx, propertyKey, newValue, metadata);
        }
    }

    public <T extends Element> void updatePropertyIfValueIsOlder(ElementUpdateContext<T> ctx, String propertyKey, ZonedDateTime newValue, PropertyMetadata metadata, Long timestamp) {
        if (this.isDateOlder(ctx.getElement(), propertyKey, newValue)) {
            this.updateProperty(ctx, propertyKey, newValue, metadata, timestamp);
        }
    }

    public <T extends Element> void updatePropertyIfValueIsOlder(ElementUpdateContext<T> ctx, String propertyKey, ZonedDateTime newValue, PropertyMetadata metadata) {
        if (this.isDateOlder(ctx.getElement(), propertyKey, newValue)) {
            this.updateProperty(ctx, propertyKey, newValue, metadata);
        }
    }

    private <T extends Element> boolean isDateNewer(T element, String propertyKey, ZonedDateTime newValue) {
        if (element == null) {
            return true;
        }
        ZonedDateTime existingValue = (ZonedDateTime)this.getPropertyValue(element, propertyKey);
        if (existingValue == null) {
            return true;
        }
        return existingValue.compareTo(newValue) < 0;
    }

    private <T extends Element> boolean isDateOlder(T element, String propertyKey, ZonedDateTime newValue) {
        if (element == null) {
            return true;
        }
        ZonedDateTime existingValue = (ZonedDateTime)this.getPropertyValue(element, propertyKey);
        if (existingValue == null) {
            return true;
        }
        return existingValue.compareTo(newValue) > 0;
    }

    public ZonedDateTime getPropertyValueDateTimeUtc(Element element, String propertyKey) {
        return this.getPropertyValueDateTime(element, propertyKey, ZoneOffset.UTC);
    }

    public ZonedDateTime getPropertyValueDateTime(Element element, String propertyKey, ZoneId zoneId) {
        ZonedDateTime value = (ZonedDateTime)this.getPropertyValue(element, propertyKey);
        if (value == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(value.toInstant(), zoneId);
    }

    public ZonedDateTime getFirstPropertyValueDateTimeUtc(Element element) {
        return this.getFirstPropertyValueDateTime(element, ZoneOffset.UTC);
    }

    public ZonedDateTime getFirstPropertyValueDateTime(Element element, ZoneId zoneId) {
        ZonedDateTime value = (ZonedDateTime)this.getFirstPropertyValue(element);
        if (value == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(value.toInstant(), zoneId);
    }
}

