/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.properties.types;

import com.mware.core.model.properties.types.PropertyMetadata;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.values.storable.Value;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class MetadataBcProperty<TRaw> {
    private final String metadataKey;

    protected MetadataBcProperty(String metadataKey) {
        this.metadataKey = metadataKey;
    }

    public abstract Value wrap(TRaw var1);

    public abstract TRaw unwrap(Value var1);

    public String getMetadataKey() {
        return this.metadataKey;
    }

    public TRaw getMetadataValue(Metadata metadata) {
        return this.unwrap(metadata.getValue(this.getMetadataKey()));
    }

    public Collection<TRaw> getMetadataValues(Metadata metadata) {
        return metadata.getValues(this.getMetadataKey()).stream().map(this::unwrap).collect(Collectors.toList());
    }

    public TRaw getMetadataValueOrDefault(Metadata metadata, TRaw defaultValue) {
        Value value = metadata.getValue(this.getMetadataKey());
        if (value == null) {
            return defaultValue;
        }
        return this.unwrap(value);
    }

    public TRaw getMetadataValue(Metadata metadata, TRaw defaultValue) {
        if (metadata.getEntry(this.getMetadataKey()) == null) {
            return defaultValue;
        }
        return this.unwrap(metadata.getValue(this.getMetadataKey()));
    }

    public TRaw getMetadataValue(Map<String, Object> metadata) {
        return (TRaw)metadata.get(this.getMetadataKey());
    }

    public TRaw getMetadataValue(Property property) {
        return this.getMetadataValue(property.getMetadata());
    }

    public void setMetadata(Metadata metadata, TRaw value, Visibility visibility) {
        metadata.add(this.getMetadataKey(), this.wrap(value), visibility);
    }

    public void setMetadata(PropertyMetadata metadata, TRaw value, Visibility visibility) {
        metadata.add(this.getMetadataKey(), this.wrap(value), visibility);
    }

    public void setMetadata(ExistingElementMutation m, Property property, TRaw value, Visibility visibility) {
        m.setPropertyMetadata(property, this.getMetadataKey(), this.wrap(value), visibility);
    }
}

