/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.properties.types;

import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.user.User;
import com.mware.ge.Metadata;
import com.mware.ge.Visibility;
import com.mware.ge.values.storable.Value;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class PropertyMetadata {
    private static final Visibility DEFAULT_VISIBILITY = new Visibility("");
    private final ZonedDateTime modifiedDate;
    private final User modifiedBy;
    private final VisibilityJson visibilityJson;
    private final Visibility propertyVisibility;
    private final List<AdditionalMetadataItem> additionalMetadataItems = new ArrayList<AdditionalMetadataItem>();

    public PropertyMetadata(User modifiedBy, VisibilityJson visibilityJson, Visibility propertyVisibility) {
        this(ZonedDateTime.now(), modifiedBy, visibilityJson, propertyVisibility);
    }

    public PropertyMetadata(ZonedDateTime modifiedDate, User modifiedBy, VisibilityJson visibilityJson, Visibility propertyVisibility) {
        this(modifiedDate, modifiedBy, null, visibilityJson, propertyVisibility);
    }

    public PropertyMetadata(ZonedDateTime modifiedDate, User modifiedBy, Double confidence, VisibilityJson visibilityJson, Visibility propertyVisibility) {
        this.modifiedDate = modifiedDate;
        this.modifiedBy = modifiedBy;
        this.visibilityJson = visibilityJson;
        this.propertyVisibility = propertyVisibility;
    }

    public PropertyMetadata(PropertyMetadata metadata) {
        this(metadata.getModifiedDate(), metadata.getModifiedBy(), metadata.getVisibilityJson(), metadata.getPropertyVisibility());
        for (AdditionalMetadataItem item : metadata.getAdditionalMetadataItems()) {
            this.add(item.getKey(), item.getValue(), item.getVisibility());
        }
    }

    public Metadata createMetadata() {
        Metadata metadata = Metadata.create();
        BcSchema.MODIFIED_DATE_METADATA.setMetadata(metadata, this.modifiedDate, DEFAULT_VISIBILITY);
        BcSchema.MODIFIED_BY_METADATA.setMetadata(metadata, this.modifiedBy.getUserId(), DEFAULT_VISIBILITY);
        BcSchema.VISIBILITY_JSON_METADATA.setMetadata(metadata, this.visibilityJson, DEFAULT_VISIBILITY);
        for (AdditionalMetadataItem additionalMetadataItem : this.additionalMetadataItems) {
            metadata.add(additionalMetadataItem.getKey(), additionalMetadataItem.getValue(), additionalMetadataItem.getVisibility());
        }
        return metadata;
    }

    public User getModifiedBy() {
        return this.modifiedBy;
    }

    public ZonedDateTime getModifiedDate() {
        return this.modifiedDate;
    }

    public VisibilityJson getVisibilityJson() {
        return this.visibilityJson;
    }

    public Visibility getPropertyVisibility() {
        return this.propertyVisibility;
    }

    public Iterable<AdditionalMetadataItem> getAdditionalMetadataItems() {
        return this.additionalMetadataItems;
    }

    public void add(String key, Value value, Visibility visibility) {
        this.additionalMetadataItems.add(new AdditionalMetadataItem(key, value, visibility));
    }

    private static class AdditionalMetadataItem {
        private final String key;
        private final Value value;
        private final Visibility visibility;

        public AdditionalMetadataItem(String key, Value value, Visibility visibility) {
            this.key = key;
            this.value = value;
            this.visibility = visibility;
        }

        public String getKey() {
            return this.key;
        }

        public Value getValue() {
            return this.value;
        }

        public Visibility getVisibility() {
            return this.visibility;
        }
    }
}

