/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.properties.types;

import com.google.common.base.Preconditions;
import com.mware.core.model.clientapi.dto.ClientApiElement;
import com.mware.core.model.clientapi.dto.ClientApiProperty;
import com.mware.core.model.graph.ElementUpdateContext;
import com.mware.core.model.properties.types.BcPropertyBase;
import com.mware.core.model.properties.types.BcPropertyUpdate;
import com.mware.core.model.properties.types.BcPropertyUpdateRemove;
import com.mware.core.model.properties.types.PropertyMetadata;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.values.storable.Value;
import java.util.List;
import java.util.Map;

public abstract class SingleValueBcProperty<TRaw>
extends BcPropertyBase<TRaw> {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(SingleValueBcProperty.class);

    protected SingleValueBcProperty(String propertyName) {
        super(propertyName);
    }

    public final void setProperty(ElementMutation<?> mutation, TRaw value, Visibility visibility) {
        mutation.setProperty(this.getPropertyName(), this.wrap(value), visibility);
    }

    public final void setProperty(ElementMutation<?> mutation, TRaw value, Metadata metadata, Visibility visibility) {
        this.setProperty(mutation, value, metadata, null, visibility);
    }

    public final void setProperty(ElementMutation<?> mutation, TRaw value, Metadata metadata, Long timestamp, Visibility visibility) {
        mutation.addPropertyValue("", this.getPropertyName(), this.wrap(value), metadata, timestamp, visibility);
    }

    public final void setProperty(Element element, TRaw value, Visibility visibility, Authorizations authorizations) {
        element.setProperty(this.getPropertyName(), this.wrap(value), visibility, authorizations);
    }

    public final void setProperty(Element element, TRaw value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        element.setProperty(this.getPropertyName(), this.wrap(value), metadata, visibility, authorizations);
    }

    public void setProperty(Map<String, Value> properties, TRaw value) {
        properties.put(this.getPropertyName(), this.wrap(value));
    }

    public final TRaw getPropertyValue(Element element) {
        Value value = element != null ? element.getPropertyValue(this.getPropertyName()) : null;
        return (TRaw)(value != null ? this.getRawConverter().apply((Object)value) : null);
    }

    public final TRaw getPropertyValue(Element element, TRaw defaultValue) {
        TRaw value = this.getPropertyValue(element);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public final TRaw getPropertyValueRequired(Element element) {
        Preconditions.checkNotNull((Object)element, (Object)"Element cannot be null");
        Value value = element.getPropertyValue(this.getPropertyName());
        Preconditions.checkNotNull((Object)value, (Object)("Property value of property " + this.getPropertyName() + " cannot be null"));
        return (TRaw)this.getRawConverter().apply((Object)value);
    }

    public final TRaw getPropertyValue(Map<String, Value> map) {
        Value value = map != null ? map.get(this.getPropertyName()) : null;
        return (TRaw)(value != null ? this.getRawConverter().apply((Object)value) : null);
    }

    public TRaw getPropertyValue(ClientApiElement clientApiElement) {
        return this.getPropertyValue(clientApiElement, null);
    }

    public TRaw getPropertyValue(ClientApiElement clientApiElement, TRaw defaultValue) {
        ClientApiProperty property = clientApiElement.getProperty("", this.getPropertyName());
        if (property == null) {
            return defaultValue;
        }
        return (TRaw)property.getValue();
    }

    public boolean hasProperty(Element element) {
        return element.getProperty("", this.getPropertyName()) != null;
    }

    public Property getProperty(Element element) {
        return element.getProperty(this.getPropertyName());
    }

    public void removeProperty(Element element, Authorizations authorizations) {
        element.softDeleteProperty("", this.getPropertyName(), authorizations);
    }

    public void removeProperty(ElementMutation m, Visibility visibility) {
        m.softDeleteProperty(this.getPropertyName(), visibility);
    }

    public void removeMetadata(Metadata metadata) {
        metadata.remove(this.getPropertyName());
    }

    public void removeMetadata(Metadata metadata, Visibility visibility) {
        metadata.remove(this.getPropertyName(), visibility);
    }

    public void alterVisibility(ExistingElementMutation<?> elementMutation, Visibility newVisibility) {
        elementMutation.alterPropertyVisibility(this.getPropertyName(), newVisibility);
    }

    public void removeProperty(List<BcPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, Visibility visibility) {
        TRaw currentValue = this.getPropertyValue(element);
        if (currentValue != null) {
            long beforeDeletionTimestamp = System.currentTimeMillis() - 1L;
            this.removeProperty(m, visibility);
            changedPropertiesOut.add(new BcPropertyUpdateRemove(this, beforeDeletionTimestamp, true, false));
        }
    }

    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, TRaw newValue, Visibility visibility) {
        this.updateProperty(ctx.getProperties(), (Element)ctx.getElement(), (ElementMutation)ctx.getMutation(), newValue, (Metadata)null, null, visibility);
    }

    @Deprecated
    public void updateProperty(List<BcPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, PropertyMetadata metadata, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, newValue, metadata, null, visibility);
    }

    public void updateProperty(List<BcPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, PropertyMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata cannot be null");
        this.updateProperty(changedPropertiesOut, element, m, newValue, metadata.createMetadata(), null, metadata.getPropertyVisibility());
    }

    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, TRaw newValue, PropertyMetadata metadata) {
        this.updateProperty(ctx.getProperties(), (Element)ctx.getElement(), (ElementMutation)ctx.getMutation(), newValue, metadata.createMetadata(), null, metadata.getPropertyVisibility());
    }

    @Deprecated
    public void updateProperty(List<BcPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, PropertyMetadata metadata, Long timestamp, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, newValue, metadata == null ? null : metadata.createMetadata(), timestamp, visibility);
    }

    public void updateProperty(List<BcPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, PropertyMetadata metadata, Long timestamp) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata cannot be null");
        this.updateProperty(changedPropertiesOut, element, m, newValue, metadata.createMetadata(), timestamp, metadata.getPropertyVisibility());
    }

    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, TRaw newValue, PropertyMetadata metadata, Long timestamp) {
        this.updateProperty(ctx.getProperties(), (Element)ctx.getElement(), (ElementMutation)ctx.getMutation(), newValue, metadata.createMetadata(), timestamp, metadata.getPropertyVisibility());
    }

    public void updateProperty(List<BcPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, Metadata metadata, Visibility visibility) {
        this.updateProperty(changedPropertiesOut, element, m, newValue, metadata, null, visibility);
    }

    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, TRaw newValue, Metadata metadata, Visibility visibility) {
        this.updateProperty(ctx.getProperties(), (Element)ctx.getElement(), (ElementMutation)ctx.getMutation(), newValue, metadata, null, visibility);
    }

    public void updateProperty(List<BcPropertyUpdate> changedPropertiesOut, Element element, ElementMutation m, TRaw newValue, Metadata metadata, Long timestamp, Visibility visibility) {
        if (newValue == null) {
            LOGGER.error("passing a null value to updateProperty will not be allowed in the future: %s", this);
            return;
        }
        if (newValue instanceof String && ((String)newValue).length() == 0) {
            LOGGER.error("passing an empty string value to updateProperty will not be allowed in the future: %s", this);
            return;
        }
        Object currentValue = null;
        if (element != null) {
            currentValue = this.getPropertyValue(element);
        }
        if (currentValue == null || !this.isEquals(newValue, currentValue)) {
            this.setProperty(m, newValue, metadata, timestamp, visibility);
            changedPropertiesOut.add(new BcPropertyUpdate(this));
        }
    }

    public <T extends Element> void updateProperty(ElementUpdateContext<T> ctx, TRaw newValue, Metadata metadata, Long timestamp, Visibility visibility) {
        this.updateProperty(ctx.getProperties(), (Element)ctx.getElement(), (ElementMutation)ctx.getMutation(), newValue, metadata, timestamp, visibility);
    }
}

