/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.properties.types;

import com.mware.core.exception.BcException;
import com.mware.core.model.properties.types.BcProperty;
import com.mware.ge.Element;
import com.mware.ge.values.storable.NoValue;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.Value;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class StreamingBcProperty
extends BcProperty<StreamingPropertyValue> {
    public StreamingBcProperty(String key) {
        super(key);
    }

    public StreamingPropertyValue wrap(StreamingPropertyValue value) {
        return value;
    }

    @Override
    public StreamingPropertyValue unwrap(Value value) {
        if (value == null || value instanceof NoValue) {
            return null;
        }
        return (StreamingPropertyValue)value;
    }

    public byte[] getFirstPropertyValueAsBytes(Element element) {
        StreamingPropertyValue propertyValue = (StreamingPropertyValue)this.getFirstPropertyValue(element);
        if (propertyValue == null) {
            return null;
        }
        try {
            return IOUtils.toByteArray((InputStream)propertyValue.getInputStream());
        }
        catch (IOException e) {
            throw new BcException("Could not get byte[] from StreamingPropertyValue", e);
        }
    }

    public String getFirstPropertyValueAsString(Element element) {
        StreamingPropertyValue propertyValue = (StreamingPropertyValue)this.getFirstPropertyValue(element);
        if (propertyValue == null) {
            return null;
        }
        try {
            return IOUtils.toString((InputStream)propertyValue.getInputStream());
        }
        catch (IOException e) {
            throw new BcException("Could not get string from StreamingPropertyValue", e);
        }
    }
}

