/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.regex;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.mware.core.model.clientapi.dto.ClientApiRegex;
import com.mware.core.model.clientapi.dto.ClientApiRegexes;
import com.mware.core.model.clientapi.util.StringUtils;
import com.mware.core.model.properties.RegexSchema;
import com.mware.core.model.regex.GeRegex;
import com.mware.core.model.regex.Regex;
import com.mware.core.model.regex.RegexRepository;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.security.BcVisibility;
import com.mware.core.trace.Traced;
import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Values;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class GeRegexRepository
implements RegexRepository {
    private static final String GRAPH_REGEX_ID_PREFIX = "RGX_";
    public static final BcVisibility VISIBILITY = new BcVisibility("regex");
    private final Graph graph;
    private final Authorizations authorizations;
    private final Cache<String, Vertex> regexVertexCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();

    @Inject
    public GeRegexRepository(GraphAuthorizationRepository graphAuthorizationRepository, Graph graph) {
        this.graph = graph;
        graphAuthorizationRepository.addAuthorizationToGraph("regex");
        HashSet<String> authorizationsSet = new HashSet<String>();
        authorizationsSet.add("regex");
        authorizationsSet.add("user");
        authorizationsSet.add("administrator");
        this.authorizations = graph.createAuthorizations(authorizationsSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Regex> getAllRegexes() {
        try (QueryResultsIterable<Vertex> vertices = this.graph.query(this.authorizations).hasConceptType("__rgx").vertices();){
            ConvertingIterable<Vertex, Regex> convertingIterable = new ConvertingIterable<Vertex, Regex>(vertices){

                @Override
                protected Regex convert(Vertex vertex) {
                    return GeRegexRepository.this.createRegexFromVertex(vertex);
                }
            };
            return convertingIterable;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    @Override
    public Regex findRegexById(String regexId) {
        return this.createRegexFromVertex(this.findByIdRegexVertex(regexId, this.graph.getDefaultFetchHints()));
    }

    @Override
    public Regex findByName(String rgxName) {
        QueryResultsIterable<Vertex> vertices = this.graph.query(this.authorizations).has(RegexSchema.REGEX_NAME.getPropertyName(), Values.stringValue(rgxName)).hasConceptType("__rgx").vertices();
        Vertex vertex = IterableUtils.singleOrDefault(vertices, null);
        if (vertex == null) {
            return null;
        }
        this.regexVertexCache.put(vertex.getId(), (Object)vertex);
        return this.createRegexFromVertex(vertex);
    }

    @Override
    public Regex createRegex(String name, String pattern, String concept) {
        name = StringUtils.trimIfNull(name);
        pattern = StringUtils.trimIfNull(pattern);
        String id = GRAPH_REGEX_ID_PREFIX + this.graph.getIdGenerator().nextId();
        VertexBuilder builder = this.graph.prepareVertex(id, VISIBILITY.getVisibility(), "__rgx");
        RegexSchema.REGEX_NAME.setProperty(builder, name, VISIBILITY.getVisibility());
        RegexSchema.REGEX_PATTERN.setProperty(builder, pattern, VISIBILITY.getVisibility());
        RegexSchema.REGEX_CONCEPT.setProperty(builder, concept, VISIBILITY.getVisibility());
        GeRegex regex = this.createRegexFromVertex(builder.save(this.authorizations));
        this.graph.flush();
        return regex;
    }

    @Override
    public void updateRegex(String id, String name, String pattern, String concept) {
        name = StringUtils.trimIfNull(name);
        pattern = StringUtils.trimIfNull(pattern);
        Vertex vertex = this.graph.getVertex(id, FetchHints.ALL, this.authorizations);
        ExistingVertexMutation mutation = vertex.prepareMutation();
        RegexSchema.REGEX_NAME.setProperty(mutation, name, VISIBILITY.getVisibility());
        RegexSchema.REGEX_PATTERN.setProperty(mutation, pattern, VISIBILITY.getVisibility());
        RegexSchema.REGEX_CONCEPT.setProperty(mutation, concept, VISIBILITY.getVisibility());
        vertex = (Vertex)mutation.save(this.authorizations);
        this.regexVertexCache.put((Object)id, (Object)vertex);
        this.graph.flush();
    }

    @Override
    public void deleteRegex(String id) {
        this.graph.deleteVertex(id, this.authorizations);
        this.graph.flush();
    }

    private GeRegex createRegexFromVertex(Vertex vertex) {
        if (vertex == null) {
            return null;
        }
        return new GeRegex(vertex);
    }

    @Traced
    private Vertex findByIdRegexVertex(String id, FetchHints fetchHints) {
        Vertex vertex = (Vertex)this.regexVertexCache.getIfPresent((Object)id);
        if (vertex != null) {
            return vertex;
        }
        vertex = this.graph.getVertex(id, fetchHints, this.authorizations);
        if (vertex != null) {
            this.regexVertexCache.put((Object)id, (Object)vertex);
        }
        return vertex;
    }

    @Override
    public ClientApiRegexes toClientApi(Iterable<Regex> regexes) {
        ClientApiRegexes clientApi = new ClientApiRegexes();
        for (Regex regex : regexes) {
            clientApi.getRegexes().add(this.toClientApi(regex));
        }
        return clientApi;
    }

    @Override
    public ClientApiRegex toClientApi(Regex regex) {
        ClientApiRegex clientApi = new ClientApiRegex();
        clientApi.setId(regex.getId());
        clientApi.setName(regex.getName());
        clientApi.setPattern(regex.getPattern());
        clientApi.setConcept(regex.getConcept());
        return clientApi;
    }
}

