/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.regex;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.mware.core.model.regex.RegexEntry;
import com.mware.core.model.user.UserRepository;
import com.mware.core.orm.Entity;
import com.mware.core.orm.SimpleOrmContext;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.user.User;

public class RegexEntryRepository {
    private static final String VISIBILITY_STRING = "";
    private final SimpleOrmSession simpleOrmSession;
    private final UserRepository userRepository;

    @Inject
    public RegexEntryRepository(SimpleOrmSession simpleOrmSession, UserRepository userRepository) {
        this.simpleOrmSession = simpleOrmSession;
        this.userRepository = userRepository;
    }

    public Iterable<RegexEntry> findAll(User user) {
        return this.simpleOrmSession.findAll(RegexEntry.class, this.userRepository.getSimpleOrmContext(user));
    }

    public Iterable<RegexEntry> findByIdStartsWith(SimpleOrmContext simpleOrmContext, String prefix) {
        return this.simpleOrmSession.findByIdStartsWith(RegexEntry.class, prefix, simpleOrmContext);
    }

    public Iterable<RegexEntry> findById(String id, User user) {
        return this.simpleOrmSession.findByIdStartsWith(RegexEntry.class, id, this.userRepository.getSimpleOrmContext(user));
    }

    public Iterable<RegexEntry> findByName(String name, User user) {
        Iterable<RegexEntry> rows = this.findAll(user);
        return Iterables.filter(rows, regexEntry -> regexEntry.getName().equals(name));
    }

    public void delete(String id, User user) {
        this.simpleOrmSession.delete(RegexEntry.class, id, this.userRepository.getSimpleOrmContext(user));
    }

    public void deleteAll(User user) {
        this.simpleOrmSession.deleteTable(this.simpleOrmSession.getTablePrefix() + ((Entity[])RegexEntry.class.getAnnotationsByType(Entity.class))[0].tableName(), this.userRepository.getSimpleOrmContext(user));
    }

    public RegexEntry createNew(String name, String pattern, String concept) {
        return new RegexEntry(name, pattern, concept);
    }

    public RegexEntry saveNew(String name, String pattern, String concept, User user) {
        RegexEntry entry = this.createNew(name, pattern, concept);
        this.simpleOrmSession.save(entry, VISIBILITY_STRING, this.userRepository.getSimpleOrmContext(user));
        return entry;
    }

    public void updateRegexEntry(RegexEntry entry, User user) {
        this.simpleOrmSession.save(entry, VISIBILITY_STRING, this.userRepository.getSimpleOrmContext(user));
    }
}

