/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.role;

import com.google.common.base.Preconditions;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.model.clientapi.dto.ClientApiRole;
import com.mware.core.model.clientapi.dto.ClientApiRoles;
import com.mware.core.model.clientapi.dto.Privilege;
import com.mware.core.model.notification.ExpirationAge;
import com.mware.core.model.notification.UserNotification;
import com.mware.core.model.notification.UserNotificationRepository;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.role.Role;
import com.mware.core.model.role.RoleListener;
import com.mware.core.model.user.UserListener;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.user.User;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;

public abstract class AuthorizationRepositoryBase
implements AuthorizationRepository {
    private final Graph graph;
    private UserRepository userRepository;
    private final UserNotificationRepository userNotificationRepository;
    private final WebQueueRepository webQueueRepository;
    private final Configuration configuration;
    private Collection<RoleListener> roleListeners;
    private Collection<UserListener> userListeners;
    private Role administratorRole;

    protected AuthorizationRepositoryBase(Graph graph, UserNotificationRepository userNotificationRepository, WebQueueRepository webQueueRepository, Configuration configuration) {
        this.graph = graph;
        this.userNotificationRepository = userNotificationRepository;
        this.webQueueRepository = webQueueRepository;
        this.configuration = configuration;
    }

    @Override
    public Authorizations getGraphAuthorizations(String userName, String ... additionalAuthorizations) {
        User user = this.getUserRepository().findByUsername(userName);
        if (user == null) {
            return new Authorizations(new String[0]);
        }
        return this.getGraphAuthorizations(user, additionalAuthorizations);
    }

    @Override
    public Authorizations getGraphAuthorizations(User user, String ... additionalAuthorizations) {
        Preconditions.checkNotNull((Object)user, (Object)"User cannot be null");
        Set<String> userAuthorizations = this.getRoles(user).stream().map(role -> role.getRoleName()).collect(Collectors.toSet());
        Collections.addAll(userAuthorizations, additionalAuthorizations);
        return this.graph.createAuthorizations(userAuthorizations);
    }

    protected UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }

    protected void sendNotificationToUserAboutAddRole(User user, Role role, User authUser) {
        String title = "Role Added";
        String message = "Role Added: " + role.getRoleName();
        String actionEvent = null;
        JSONObject actionPayload = null;
        ExpirationAge expirationAge = null;
        UserNotification userNotification = this.userNotificationRepository.createNotification(user.getUserId(), title, message, actionEvent, actionPayload, expirationAge, authUser);
        this.webQueueRepository.pushUserNotification(userNotification);
    }

    protected void sendNotificationToUserAboutRemoveRole(User user, Role role, User authUser) {
        String title = "Role Removed";
        String message = "Role Removed: " + role.getRoleName();
        String actionEvent = null;
        JSONObject actionPayload = null;
        ExpirationAge expirationAge = null;
        UserNotification userNotification = this.userNotificationRepository.createNotification(user.getUserId(), title, message, actionEvent, actionPayload, expirationAge, authUser);
        this.webQueueRepository.pushUserNotification(userNotification);
    }

    protected void fireUserAddRoleEvent(User user, Role role) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userAddRole(user, role);
        }
    }

    protected void fireUserRemoveRoleEvent(User user, Role role) {
        for (UserListener userListener : this.getUserListeners()) {
            userListener.userRemoveRole(user, role);
        }
    }

    protected void fireNewRoleAddedEvent(Role role) {
        for (RoleListener roleListener : this.getRoleListeners()) {
            roleListener.newRoleAdded(role);
        }
    }

    protected void fireRoleDeletedEvent(Role role) {
        for (RoleListener roleListener : this.getRoleListeners()) {
            roleListener.roleDeleted(role);
        }
    }

    protected Collection<RoleListener> getRoleListeners() {
        if (this.roleListeners == null) {
            this.roleListeners = InjectHelper.getInjectedServices(RoleListener.class, this.configuration);
        }
        return this.roleListeners;
    }

    protected Collection<UserListener> getUserListeners() {
        if (this.userListeners == null) {
            this.userListeners = InjectHelper.getInjectedServices(UserListener.class, this.configuration);
        }
        return this.userListeners;
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public ClientApiRoles toClientApi(Iterable<Role> roles) {
        ClientApiRoles clientApiRoles = new ClientApiRoles();
        for (Role role : roles) {
            clientApiRoles.getRoles().add(this.toClientApi(role));
        }
        return clientApiRoles;
    }

    @Override
    public ClientApiRole toClientApi(Role role) {
        ClientApiRole clientApiRole = new ClientApiRole();
        clientApiRole.setId(role.getRoleId());
        clientApiRole.setRoleName(role.getRoleName());
        clientApiRole.setDescription(role.getDescription());
        clientApiRole.setGlobal(role.isGlobal());
        Set privileges = role.getPrivileges().stream().map(p -> p.getName()).collect(Collectors.toSet());
        clientApiRole.getPrivileges().addAll(privileges);
        return clientApiRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role getAdministratorRole() {
        if (this.administratorRole == null) {
            AuthorizationRepositoryBase authorizationRepositoryBase = this;
            synchronized (authorizationRepositoryBase) {
                if (this.administratorRole == null) {
                    this.administratorRole = this.findByName("administrator");
                    if (this.administratorRole == null) {
                        this.administratorRole = this.addRole("administrator", "System Administrator", true, Privilege.ALL_BUILT_IN);
                    }
                }
            }
        }
        return this.administratorRole;
    }
}

