/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.role;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcResourceNotFoundException;
import com.mware.core.model.clientapi.dto.Privilege;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.notification.UserNotificationRepository;
import com.mware.core.model.properties.RoleSchema;
import com.mware.core.model.role.AuthorizationRepositoryBase;
import com.mware.core.model.role.GeRole;
import com.mware.core.model.role.Role;
import com.mware.core.model.user.AuthorizationContext;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.security.BcVisibility;
import com.mware.core.trace.Traced;
import com.mware.core.user.SystemUser;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.StreamUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Values;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class GeAuthorizationRepository
extends AuthorizationRepositoryBase {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(GeAuthorizationRepository.class);
    private static final String GRAPH_ROLE_ID_PREFIX = "ROLE_";
    public static final String VISIBILITY_STRING = "role";
    public static final BcVisibility VISIBILITY = new BcVisibility("role");
    private Authorizations authorizations;
    private final GraphAuthorizationRepository graphAuthorizationRepository;
    private final LockRepository lockRepository;
    private final WebQueueRepository webQueueRepository;
    private String roleConceptId = "__rl";
    private final Cache<String, Vertex> roleVertexCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();

    @Inject
    public GeAuthorizationRepository(Graph graph, GraphAuthorizationRepository graphAuthorizationRepository, Configuration configuration, UserNotificationRepository userNotificationRepository, WebQueueRepository webQueueRepository, LockRepository lockRepository) {
        super(graph, userNotificationRepository, webQueueRepository, configuration);
        this.webQueueRepository = webQueueRepository;
        this.graphAuthorizationRepository = graphAuthorizationRepository;
        this.graphAuthorizationRepository.addAuthorizationToGraph(VISIBILITY_STRING);
        this.graphAuthorizationRepository.addAuthorizationToGraph("user");
        this.graphAuthorizationRepository.addAuthorizationToGraph("administrator");
        this.lockRepository = lockRepository;
        HashSet<String> authorizationsSet = new HashSet<String>();
        authorizationsSet.add(VISIBILITY_STRING);
        authorizationsSet.add("user");
        authorizationsSet.add("administrator");
        this.authorizations = graph.createAuthorizations(authorizationsSet);
    }

    @Override
    public void updateUser(User user, AuthorizationContext authorizationContext) {
    }

    @Override
    public Set<Role> getRoles(User user) {
        if (user instanceof SystemUser) {
            return Sets.newHashSet((Object[])new Role[]{this.getAdministratorRole()});
        }
        Vertex userVertex = this.getGraph().getVertex(user.getUserId(), FetchHints.ALL, this.authorizations);
        return StreamUtil.stream(userVertex.getVertices(Direction.IN, "roleToUser", this.authorizations)).map(GeRole::new).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getRoleNames(User user) {
        return this.getRoles(user).stream().map(Role::getRoleName).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Role> getAllRoles() {
        try (QueryResultsIterable<Vertex> roleVertices = this.getGraph().query(this.authorizations).hasConceptType(this.roleConceptId).vertices();){
            ConvertingIterable<Vertex, Role> convertingIterable = new ConvertingIterable<Vertex, Role>(roleVertices){

                @Override
                protected Role convert(Vertex vertex) {
                    return GeAuthorizationRepository.this.createFromVertex(vertex);
                }
            };
            return convertingIterable;
        }
        catch (Exception e) {
            throw new GeException("Could not close scroll iterable: ", e);
        }
    }

    @Override
    public Role findById(String roleId) {
        return this.createFromVertex(this.findByIdRoleVertex(roleId, this.getGraph().getDefaultFetchHints()));
    }

    @Override
    public Role findByName(String roleName) {
        roleName = this.formatRole(roleName);
        QueryResultsIterable<Vertex> vertices = this.getGraph().query(this.authorizations).has(RoleSchema.ROLE_NAME.getPropertyName(), Values.stringValue(roleName)).hasConceptType(this.roleConceptId).vertices();
        Vertex roleVertex = IterableUtils.singleOrDefault(vertices, null);
        if (roleVertex == null) {
            return null;
        }
        this.roleVertexCache.put(roleVertex.getId(), (Object)roleVertex);
        return this.createFromVertex(roleVertex);
    }

    private String formatRole(String roleName) {
        return roleName.trim().toLowerCase();
    }

    @Override
    public Role addRole(String roleName, String description, boolean global, Set<Privilege> privileges) {
        roleName = this.formatRole(roleName);
        description = description.trim();
        String id = GRAPH_ROLE_ID_PREFIX + this.getGraph().getIdGenerator().nextId();
        VertexBuilder roleBuilder = this.getGraph().prepareVertex(id, VISIBILITY.getVisibility(), this.roleConceptId);
        RoleSchema.ROLE_NAME.setProperty(roleBuilder, roleName, VISIBILITY.getVisibility());
        RoleSchema.DESCRIPTION.setProperty(roleBuilder, description, VISIBILITY.getVisibility());
        RoleSchema.GLOBAL.setProperty(roleBuilder, global, VISIBILITY.getVisibility());
        RoleSchema.PRIVILEGES.setProperty(roleBuilder, Privilege.toStringPrivileges(privileges), VISIBILITY.getVisibility());
        GeRole role = this.createFromVertex(roleBuilder.save(this.authorizations));
        this.getGraph().flush();
        this.fireNewRoleAddedEvent(role);
        return role;
    }

    @Override
    public void deleteRole(Role role) {
        Vertex roleVertex = this.findByIdRoleVertex(role.getRoleId(), this.getGraph().getDefaultFetchHints());
        this.getGraph().softDeleteVertex(roleVertex, this.authorizations);
        this.getGraph().flush();
        this.fireRoleDeletedEvent(role);
    }

    @Override
    public void setRoleName(Role role, String roleName) {
        Vertex roleVertex = this.findByIdRoleVertex(role.getRoleId(), this.getGraph().getDefaultFetchHints());
        RoleSchema.ROLE_NAME.setProperty(roleVertex, roleName, VISIBILITY.getVisibility(), this.authorizations);
        this.getGraph().flush();
    }

    @Override
    public void setDescription(Role role, String description) {
        Vertex roleVertex = this.findByIdRoleVertex(role.getRoleId(), this.getGraph().getDefaultFetchHints());
        RoleSchema.DESCRIPTION.setProperty(roleVertex, description, VISIBILITY.getVisibility(), this.authorizations);
        this.getGraph().flush();
    }

    @Override
    public void setPrivileges(Role role, Set<Privilege> privileges) {
        Vertex roleVertex = this.findByIdRoleVertex(role.getRoleId(), this.getGraph().getDefaultFetchHints());
        String value = Privilege.toStringPrivileges(privileges);
        RoleSchema.PRIVILEGES.setProperty(roleVertex, value, VISIBILITY.getVisibility(), this.authorizations);
        this.getGraph().flush();
    }

    @Override
    public void setGlobal(Role role, boolean global) {
        Vertex roleVertex = this.findByIdRoleVertex(role.getRoleId(), this.getGraph().getDefaultFetchHints());
        RoleSchema.GLOBAL.setProperty(roleVertex, Boolean.valueOf(global), VISIBILITY.getVisibility(), this.authorizations);
        this.getGraph().flush();
    }

    @Override
    public void addRoleToUser(User user, String roleName, User authUser) {
        Role role = this.findByName(roleName);
        if (role == null) {
            role = this.addRole(roleName, "", true, Collections.emptySet());
        }
        this.addRoleToUser(user, role, authUser);
        this.getGraph().flush();
    }

    @Override
    public void addRoleToUser(User user, Role role, User authUser) {
        Set<Role> roles = this.getRoles(user);
        if (!roles.contains(role)) {
            LOGGER.info("Adding role '%s' to user '%s' by '%s'", role.getRoleName(), user.getUsername(), authUser.getUsername());
            Vertex roleVertex = this.findByIdRoleVertex(role.getRoleId(), FetchHints.ALL);
            Vertex userVertex = this.getGraph().getVertex(user.getUserId(), FetchHints.ALL, this.authorizations);
            EdgeBuilder edgeBuilder = this.getGraph().prepareEdge(roleVertex, userVertex, "roleToUser", VISIBILITY.getVisibility());
            edgeBuilder.save(this.authorizations);
            this.graphAuthorizationRepository.addAuthorizationToGraph(role.getRoleName());
            this.sendNotificationToUserAboutAddRole(user, role, authUser);
            this.webQueueRepository.pushUserAccessChange(user);
            this.fireUserAddRoleEvent(user, role);
        }
    }

    @Override
    public void addRolesToUser(User user, Set<Role> role, User authUser) {
        Set<Role> existingRoles = this.getRoles(user);
        role.stream().filter(r -> !existingRoles.contains(r)).forEach(r -> this.addRoleToUser(user, (Role)r, authUser));
        this.getGraph().flush();
    }

    @Override
    public void setRolesForUser(User user, Set<Role> newRoles, User authUser) {
        this.removeAllRolesFromUser(user);
        for (Role role : newRoles) {
            this.addRoleToUser(user, role, authUser);
        }
        this.getGraph().flush();
        this.webQueueRepository.pushUserAccessChange(user);
    }

    private void removeAllRolesFromUser(User user) {
        Set<Role> roles = this.getRoles(user);
        for (Role role : roles) {
            this.lockRepository.lock(GRAPH_ROLE_ID_PREFIX + role.getRoleId(), () -> {
                Vertex userVertex = this.getGraph().getVertex(user.getUserId(), FetchHints.ALL, this.authorizations);
                if (userVertex == null) {
                    throw new BcResourceNotFoundException("Could not find user: " + user.getUserId(), user.getUserId());
                }
                Vertex roleVertex = this.findByIdRoleVertex(role.getRoleId(), FetchHints.ALL);
                if (roleVertex == null) {
                    throw new BcResourceNotFoundException("Could not find role: " + role.getRoleId(), role.getRoleId());
                }
                List edges = StreamUtil.stream(roleVertex.getEdges(userVertex, Direction.BOTH, "roleToUser", this.authorizations)).collect(Collectors.toList());
                for (Edge edge : edges) {
                    this.getGraph().softDeleteEdge(edge, this.authorizations);
                }
            });
        }
        this.getGraph().flush();
    }

    @Override
    public void removeRoleFromUser(User user, Role role, User authUser) {
        Set<Role> roles = this.getRoles(user);
        if (roles.contains(role)) {
            LOGGER.info("Removing role '%s' to user '%s' by '%s'", role.getRoleName(), user.getUsername(), authUser.getUsername());
            this.lockRepository.lock(GRAPH_ROLE_ID_PREFIX + role.getRoleId(), () -> {
                Vertex userVertex = this.getGraph().getVertex(user.getUserId(), FetchHints.ALL, this.authorizations);
                if (userVertex == null) {
                    throw new BcResourceNotFoundException("Could not find user: " + user.getUserId(), user.getUserId());
                }
                Vertex roleVertex = this.findByIdRoleVertex(role.getRoleId(), FetchHints.ALL);
                if (roleVertex == null) {
                    throw new BcResourceNotFoundException("Could not find role: " + role.getRoleId(), role.getRoleId());
                }
                List edges = StreamUtil.stream(roleVertex.getEdges(userVertex, Direction.BOTH, "roleToUser", this.authorizations)).collect(Collectors.toList());
                for (Edge edge : edges) {
                    this.getGraph().softDeleteEdge(edge, this.authorizations);
                }
                this.getGraph().flush();
            });
            this.sendNotificationToUserAboutRemoveRole(user, role, authUser);
            this.webQueueRepository.pushUserAccessChange(user);
            this.fireUserRemoveRoleEvent(user, role);
        }
    }

    private GeRole createFromVertex(Vertex role) {
        if (role == null) {
            return null;
        }
        return new GeRole(role);
    }

    @Traced
    private Vertex findByIdRoleVertex(String roleId, FetchHints fetchHints) {
        Vertex roleVertex = (Vertex)this.roleVertexCache.getIfPresent((Object)roleId);
        if (roleVertex != null) {
            return roleVertex;
        }
        roleVertex = this.getGraph().getVertex(roleId, fetchHints, this.authorizations);
        if (roleVertex != null) {
            this.roleVertexCache.put((Object)roleId, (Object)roleVertex);
        }
        return roleVertex;
    }
}

