/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.model.role;

import com.mware.core.model.clientapi.dto.Privilege;
import com.mware.core.model.properties.RoleSchema;
import com.mware.core.model.role.Role;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.values.storable.Value;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GeRole
implements Role,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String roleId;
    private final Map<String, Value> properties = new HashMap<String, Value>();

    public GeRole(Vertex roleVertex) {
        this.roleId = roleVertex.getId();
        for (Property property : roleVertex.getProperties()) {
            this.properties.put(property.getName(), property.getValue());
        }
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    public String getRoleName() {
        return (String)RoleSchema.ROLE_NAME.getPropertyValue(this.properties);
    }

    @Override
    public String getDescription() {
        return (String)RoleSchema.DESCRIPTION.getPropertyValue(this.properties);
    }

    @Override
    public Boolean isGlobal() {
        return (Boolean)RoleSchema.GLOBAL.getPropertyValue(this.properties);
    }

    @Override
    public Set<Privilege> getPrivileges() {
        String privs = (String)RoleSchema.PRIVILEGES.getPropertyValue(this.properties);
        if (privs != null) {
            Set<String> set = Privilege.stringToPrivileges(privs);
            return set.stream().map(privilegeName -> new Privilege((String)privilegeName)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public boolean equals(Object obj) {
        return obj instanceof Role && ((Role)obj).getRoleName().equals(this.getRoleName());
    }
}

